<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingProAdminWooPanel\app\helpers\EmailHelper;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_email_type=EmailHelper::get_list_email_type();
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-emailtype">
        <select name="<?php esc_attr_e($name); ?>"
                class="form-control list-emailtype">
            <option value=""><?php esc_attr_e('Select email type','wpbookingpro')?></option>
            <?php foreach ($list_email_type as $item) { ?>
                <option <?php echo (EmailHelper::check_in_array_mail_type($value) ? " selected " : "") ?>
                        value="<?php esc_attr_e($item->type); ?>"><?php esc_html_e($item->description); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/emailtype/emailtype.less');
$doc->addScriptApplySelector('.field-emailtype','field_emailtype',array(
        'field_name'=> $name
),'admin/app/layouts/WooBooking/form/field/emailtype/emailtype.js');