<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);

?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> element-field-closetime">
        <input type="text" id="close-time" class="form-control close-time" value="<?php esc_html_e($value);?>" />
        <input type="hidden" name="<?php esc_html_e($name);?>" />
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlBackend::load_jquery_library('moment');
WpBookingProHtmlBackend::load_jquery_library('daterangepicker');
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/closetime/closetime.less');
$doc->addScriptApplySelector('.element-field-closetime','field_closetime',array(
    'input_name'=>$name,
    'value'=>$value
),'admin/app/layouts/WooBooking/form/field/closetime/closetime.jquery.js');
