<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);

?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-buffer-time hide-option">
        <select class="time-buffer" name="<?php esc_html_e($name); ?>">
            <?php for ($i = 0; $i <= 23; $i++) { ?>
                <?php if ($i !== 0) { ?>
                    <option <?php echo($value == $i ? ' selected ' : '') ?>
                            value="<?php esc_html_e($i); ?>"><?php printf("%sh", $i) ?></option>
                    <option <?php echo($value == ($i + 0.5) ? ' selected ' : '') ?>
                            value="<?php echo($i + 0.5) ?>"><?php printf("%sh 30min", $i) ?></option>
                <?php } else { ?>
                    <option <?php echo($value == $i ? ' selected ' : '') ?>
                            value="<?php esc_html_e($i); ?>"><?php esc_attr_e('30min','wpbookingpro') ?></option>
                <?php } ?>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/buffertime/buffertime.less');
$doc->addScriptApplySelector('#'.$id_by_name,'field_buffertime',array(
    "field_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/buffertime/buffertime.jquery.js');
