<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlWooPanelAlias::load_jquery_library('moment');
WpBookingProHtmlWooPanelAlias::load_jquery_library('daterangepicker');
WpBookingProHtmlWooPanelAlias::load_jquery_library('auto_numeric');
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();

$modelCategories = Model::getInstance('categories');
$list_category = $modelCategories->getList();
$input = Factory::getInput();
$employee_id = $input->getInt('id',0);
$modelEmployee = Model::getInstance('employee');
if($employee_id > 0) {
    $employee = $modelEmployee->getItem($employee_id);
}else {
    $employee = array();
}


$template_employee_custom = function ($field_name_start_time, $value_start_time,$field_name_end_time, $value_end_time, $field_name_price, $price) {

    ob_start();
    ?>
    <div class="wrapper-item-employee-custom">
        <div class="block-start-time">
            <label class="label-start-time">
                <?php esc_html_e('Start time','wpbookingpro'); ?>
                <input type="text" class="start-time-input" value="<?php echo (esc_attr($value_start_time))?>">
                <input type="hidden" name="<?php echo (esc_attr($field_name_start_time.'[]'))?>" value="<?php echo (esc_attr($value_start_time))?>">
            </label>
        </div>
        <div class="block-end-time">
            <label class="label-start-time">
                <?php esc_html_e('End time','wpbookingpro'); ?>
                <input type="text" class="end-time-input" value="<?php echo (esc_attr($value_end_time))?>">
                <input type="hidden" name="<?php echo (esc_attr($field_name_end_time.'[]'))?>" value="<?php echo (esc_attr($value_end_time))?>">
            </label>
        </div>
        <div class="block-price">
            <label class="label-price">
                <?php esc_html_e('Price','wpbookingpro'); ?>
                <input type="text" class="price-input" value="<?php echo (esc_attr($price))?>" data-a-sign="$">
                <input type="hidden" name="<?php echo (esc_attr($field_name_price.'[]'))?>" value="<?php echo (esc_attr($price))?>">
            </label>
        </div>
        <div class="button-action">
            <button type="button" class="btn btn-primary btn-add-employee-custom"><i class="far fa-copy"></i></button>
            <button type="button" class="btn btn-danger btn-delete-employee-custom"><i class="far fa-trash-alt"></i></button>
        </div>
    </div>
    <?php
    $content = ob_get_clean();
    return $content;
};


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-asignservice">
        <div class="row">
        <?php  foreach ($list_category as  $category) {?>
            <div class="col-md-6">
                <div class="wrapper-category-block">
                    <div class="title">
                        <h5><?php echo (esc_html(isset($category->name)?$category->name:''))?></h5>
                    </div>
                    <?php foreach ($category->list_service as $service) {?>
                        <?php
                            $list_employee_id = array_map(function ($v){
                                return $v->employee_id;
                            },$service->list_employee);

                            $service_name = strtolower(str_replace(' ','-', $service->name));

                        ?>
                        <div class="wrapper-service" >
                            <div class="block-service-item" data-service_id="<?php echo (esc_attr($service->id))?>">
                                <label class="service-name">
                                    <input type="checkbox" class="ckb-service-name" name="<?php echo (esc_attr($field_name_service.'[]'))?>" value="<?php echo (esc_attr($service->id))?>"
                                        <?php echo (esc_attr(in_array($employee_id, $list_employee_id)?'checked':''))?>
                                    />
                                    <?php echo (esc_html($service->name))?>
                                </label>
                                <div class="wrapper-custom">
                                    <?php
                                    if(empty((array)$employee)) {
                                        echo ($template_employee_custom($field_name_start_time,'',$field_name_end_time,'',$field_name_price,''));
                                    } elseif (count((array)$employee) == 1 && trim((array)$employee['0']) == '') {
                                        echo ($template_employee_custom($field_name_start_time,'',$field_name_end_time,'',$field_name_price,''));
                                    } else {
                                        if(in_array($employee_id,$list_employee_id)) {
                                            foreach ($service->list_employee as $employee_item) {
                                                if($employee_item->employee_id == $employee_id) {
                                                    echo ($template_employee_custom($field_name_start_time,$employee_item->start_time,$field_name_end_time,$employee_item->end_time,$field_name_price,$employee_item->price));
                                                }
                                            }
                                        }else {
                                            echo ($template_employee_custom($field_name_start_time,'',$field_name_end_time,'',$field_name_price,''));
                                        }

                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
        </div>
        <input type="hidden" name="order_service">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/asignservice/asignservice.less');
$doc->addScriptApplySelector('.field-asignservice','field_asignservice',array(
    'field_name_start_time'=> $field_name_start_time.'[]',
    'field_name_end_time'=> $field_name_end_time.'[]',
    'field_name_price'=> $field_name_price.'[]',
    "list_category"=>$list_category,
    "item_employee_custom"=>$template_employee_custom($field_name_start_time,'',$field_name_end_time,'',$field_name_price,'')
),'admin_woopanel/app/layouts/WooBooking/form/field/asignservice/asignservice.jquery.js');