"use strict";
(function ($) {
    $.view_list_calendar = function (element, options) {
        let defaults = {
            list_order: []
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.up_event = function (id, start, end) {
            let data = {
                id: id,
                from: start,
                to: end,
                task: "orderdetailrate.save_change_time_order"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        $.alert({
                            title: 'Success',
                            content: 'update day success !',
                        });
                    } else {
                        $.alert({
                            title: 'Error',
                            content: response.msg
                        });
                    }
                }
            });
        };
        plugin.get_full_time = function (date) {
            let current_datetime = new Date(date);
            let formatted_date = current_datetime.getFullYear() + "-" + (current_datetime.getMonth() + 1) + "-" + current_datetime.getDate() + " " + current_datetime.getHours() + ":" + current_datetime.getMinutes() + ":" + current_datetime.getSeconds();
            return formatted_date;
        };
        plugin.create_Appointment = function (info) {
            let start = plugin.get_full_time(info.startStr);
            let end = plugin.get_full_time(info.endStr);
            let data = {
                from: start,
                to: end,
                task: "appointment.ajax_get_item"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                    } else {
                        $.alert({
                            title: 'Error',
                            content: response.msg
                        });
                    }
                }
            });
        };
        plugin.filter_order_by_employee = function (employee_id) {
            let data = {
                id: employee_id,
                task: "calendar.get_order_by_employee_id"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        let list_order = response.data;
                        let list_rate = [];
                        $.each(list_order,function (index, item) {
                            list_rate.push(item.list_rate)
                        });
                        var calendarEl = document.getElementById('calendar');
                        var calendar = new FullCalendar.Calendar(calendarEl, {
                            plugins: ['interaction', 'dayGrid', 'timeGrid', 'bootstrapPlugin', 'interactionPlugin', 'momentPlugin', 'rrule'],
                            selectable: true,
                            header: {
                                left: 'prev,next today',
                                center: 'title',
                                right: 'dayGridMonth,timeGridWeek,timeGridDay'
                            },
                            select: function (info) {
                                //plugin.create_Appointment(info);
                            },
                            droppable: true,
                            themeSystem: 'bootstrap',
                            events:list_rate,
                            color: 'yellow',
                            textColor: 'black',
                            editable: true,
                            eventLimit: true, // for all non-TimeGrid views
                            views: {
                                dayGrid: {
                                    eventLimit: 2 // adjust to 6 only for timeGridWeek/timeGridDay
                                }
                            },
                            eventDrop: function (info, delta, revertFunc) {
                                let id = info.event.id;
                                let start = plugin.get_full_time(info.event.start);
                                let end = plugin.get_full_time(info.event.end);
                                if(info.event._def.extendedProps.is_recurring === '0') {
                                    plugin.up_event(id, start, end);
                                }

                            },
                            eventResize: function (info) {
                                let id = info.event.id;
                                let start = plugin.get_full_time(info.event.start);
                                let end = plugin.get_full_time(info.event.end);
                                if(info.event._def.extendedProps.is_recurring === '0') {
                                    plugin.up_event(id, start, end);
                                }

                            },
                            eventClick: function (event, element) {
                            },
                            eventRender: function (info) {
                                $(info.el).css('background-color', info.event._def.extendedProps.service_color)
                                $(info.el).find('.fc-title').append('<i class="icon-nb-calendar"></i>')
                                $(info.el).find(".fc-content").append(`
                                    <p class="time-booking">${info.event._def.extendedProps.list_time_detail}</p>
                                    <div class="employee">
                                            <div class="img-box">
                                                <div>
                                                    <img src="${wpbookingpro_root_url_plugin}${info.event._def.extendedProps.employee_cover}" alt="">
                                                </div>
                                            </div>
                                            <span>${info.event._def.extendedProps.employee_fullname}</span>
                                    </div>
                                `
                                );
                                if(info.event._def.extendedProps.is_recurring === '1') {
                                    if(info.event._def.extendedProps.type_recurring === 'daily') {
                                        $(info.el).find(".fc-content").append('<span class="is-recurring" style="background-color: #a0e4a0">Daily</span>');
                                    } else if(info.event._def.extendedProps.type_recurring === 'weekly') {
                                        $(info.el).find(".fc-content").append('<span class="is-recurring" style="background-color: #fdd07e">Weekly</span>');
                                    } else if(info.event._def.extendedProps.type_recurring === 'monthly') {
                                        $(info.el).find(".fc-content").append('<span class="is-recurring" style="background-color: #e89de8">Monthly</span>');
                                    }
                                }
                                $(info.el).popover({
                                    html: true,
                                    content: function () {
                                        let $html = `
                                            <p class="time-booking"><i class="icon-nb-clock"></i> <span>${info.event._def.extendedProps.list_time_detail}</span></p>
                                            <p class="location-booking"><i class="icon-nb-pin"></i> <span>${info.event._def.extendedProps.location_address}</span></p>
                                            <p class="customer-booking"><i class="icon-nb-email"></i> <span>${info.event._def.extendedProps.customer_email}</span> </p>
                                            <div class="employee-booking">
                                                <div class="img-box">
                                                    <div>
                                                        <img src="${wpbookingpro_root_url_plugin}${info.event._def.extendedProps.employee_cover}" alt="">
                                                    </div>
                                                </div>
                                                <span>${info.event._def.extendedProps.employee_fullname}</span>
                                            </div>
                                           
                                        `;
                                        return $html;
                                    },
                                    title: function () {
                                        let $title = `
                                            <span>${info.event.title}</span>
                                            <div class="color" style="background-color: ${info.event._def.extendedProps.service_color}"></div>
                                        `;
                                        return $title;
                                    },
                                    delay: {"show": 500, "hide": 100},
                                    placement: "top",
                                    trigger: 'manual'
                                }).on('mouseenter', function () {
                                    var _this = this;
                                    $(this).popover('show');
                                    $('.popover').on('mouseleave', function () {
                                        $(_this).popover('hide');
                                    });
                                }).on('mouseleave', function () {
                                    var _this = this;
                                    setTimeout(function () {
                                        if (!$('.popover:hover').length) {
                                            $(_this).popover('hide');
                                        }
                                    }, 300);
                                });
                            },
                        });
                        calendar.render();
                    } else {
                        $.alert({
                            title: 'Error',
                            content: response.msg
                        });
                    }
                }
            });
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            var calendarEl = document.getElementById('calendar');
            let list_order = plugin.settings.list_order;
            let list_rate = [];
            $.each(list_order,function (index, item) {
                list_rate.push(item.list_rate)
            });

            var calendar = new FullCalendar.Calendar(calendarEl, {
                plugins: ['interaction', 'dayGrid', 'timeGrid', 'bootstrapPlugin', 'interactionPlugin', 'momentPlugin', 'rrule'],
                selectable: true,
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                select: function (info) {
                    //plugin.create_Appointment(info);
                },
                droppable: true,
                themeSystem: 'bootstrap',
                events:list_rate,
                color: 'yellow',
                textColor: 'black',
                editable: true,
                eventLimit: true, // for all non-TimeGrid views
                views: {
                    dayGrid: {
                        eventLimit: 2 // adjust to 6 only for timeGridWeek/timeGridDay
                    }
                },
                eventDrop: function (info, delta, revertFunc) {
                    let id = info.event.id;
                    let start = plugin.get_full_time(info.event.start);
                    let end = plugin.get_full_time(info.event.end);
                    if(info.event._def.extendedProps.is_recurring === '0') {
                        plugin.up_event(id, start, end);
                    }
                },
                eventResize: function (info) {
                    let id = info.event.id;
                    let start = plugin.get_full_time(info.event.start);
                    let end = plugin.get_full_time(info.event.end);
                    if(info.event._def.extendedProps.is_recurring === '0') {
                        plugin.up_event(id, start, end);
                    }
                },
                eventClick: function (event, element) {
                },
                eventRender: function (info) {
                    $(info.el).css('background-color', info.event._def.extendedProps.service_color)
                    $(info.el).find('.fc-title').append('<i class="icon-nb-calendar"></i>')
                    $(info.el).find(".fc-content").append(`
                        <p class="time-booking">${info.event._def.extendedProps.list_time_detail}</p>
                        <div class="employee">
                                <div class="img-box">
                                    <div>
                                        <img src="${wpbookingpro_root_url_plugin}${info.event._def.extendedProps.employee_cover}" alt="">
                                    </div>
                                </div>
                                <span>${info.event._def.extendedProps.employee_fullname}</span>
                        </div>
                    `
                    );
                    if(info.event._def.extendedProps.is_recurring === '1') {
                        if(info.event._def.extendedProps.type_recurring === 'daily') {
                            $(info.el).find(".fc-content").append('<span class="is-recurring" style="background-color: #a0e4a0">Daily</span>');
                        } else if(info.event._def.extendedProps.type_recurring === 'weekly') {
                            $(info.el).find(".fc-content").append('<span class="is-recurring" style="background-color: #fdd07e">Weekly</span>');
                        } else if(info.event._def.extendedProps.type_recurring === 'monthly') {
                            $(info.el).find(".fc-content").append('<span class="is-recurring" style="background-color: #e89de8">Monthly</span>');
                        }
                    }

                    $(info.el).tooltip();
                    $(info.el).popover({
                        html: true,
                        content: function () {
                            let $html = `
                                <p class="time-booking"><i class="icon-nb-clock"></i> <span>${info.event._def.extendedProps.list_time_detail}</span></p>
                                <p class="location-booking"><i class="icon-nb-pin"></i> <span>${info.event._def.extendedProps.location_address}</span></p>
                                <p class="customer-booking"><i class="icon-nb-email"></i> <span>${info.event._def.extendedProps.customer_email}</span> </p>
                                <div class="employee-booking">
                                    <div class="img-box">
                                        <div>
                                            <img src="${wpbookingpro_root_url_plugin}${info.event._def.extendedProps.employee_cover}" alt="">
                                        </div>
                                    </div>
                                    <span>${info.event._def.extendedProps.employee_fullname}</span>
                                </div>
                               
                            `;
                            return $html;
                        },
                        title: function () {
                            let $title = `
                                <span>${info.event.title}</span>
                                <div class="color" style="background-color: ${info.event._def.extendedProps.service_color}"></div>
                            `;
                            return $title;
                        },
                        delay: {"show": 500, "hide": 500},
                        placement: "top",
                        trigger: 'manual'
                    }).on('mouseenter', function () {
                        var _this = this;
                        $(this).popover('show');
                        $('.popover').on('mouseleave', function () {
                            $(_this).popover('hide');
                        });
                    }).on('mouseleave', function () {
                        var _this = this;
                        setTimeout(function () {
                            if (!$('.popover:hover').length) {
                                $(_this).popover('hide');
                            }
                        }, 300);
                    });
                },
            });
            calendar.render();
            $element.find('li.employee-item').on('click', function () {
                $element.find('li.employee-item').removeClass('active');
                $(this).addClass('active');
                let employee_id = $(this).data('employee_id');
                $element.find('#calendar').empty();
                plugin.filter_order_by_employee(employee_id);

            });
        };
        plugin.init();
    };
    $.fn.view_list_calendar = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_list_calendar')) {
                let plugin = new $.view_list_calendar(this, options);
                $(this).data('view_list_calendar', plugin);
            }
        });
    }
})(jQuery);