<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;

defined('_WPBOOKINGPRO_EXEC') or die;

$doc = Factory::getDocument();

$id_by_name = "element_field_". $customize->field_name;
$editor_type="ckeditor";

if($editor_type=="ckeditor") {
    WpBookingProHtmlWooPanel::load_jquery_library('ckeditor');

}else {
    $settings = array(
        'media_buttons' => true,
        'quicktags' => array('buttons' => 'em,strong,link,p'),
        'textarea_name' => $customize->field_name,//name you want for the textarea
        'quicktags' => false,
        'tinymce' => array(
            'toolbar1' => 'formatselect,bold,italic,bullist,numlist,blockquote,alignleft,aligncenter,alignright,link,unlink,wp_more,spellchecker,fullscreen,wp_adv',
            'toolbar2' => 'strikethrough,hr,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help'
        ),
        'autoresize_min_height' => 250,
        'wp_autoresize_on' => true,
    );


}
?>

<div id="<?php esc_attr_e($id_by_name) ?>" class="field-editor">
    <?php if($editor_type=="ckeditor"){ ?>
        <textarea name="<?php echo (esc_attr($customize->field_name)) ?>" id="<?php echo (esc_attr($customize->field_name)) ?>" rows="10" cols="150"><?php echo (esc_attr(isset($customize->value)?$customize->value:'')) ?></textarea>
    <?php }else{ ?>
        <?php wp_editor(isset($customize->value)?$customize->value:'', $customize->field_name, $settings); ?>
    <?php } ?>
</div>

<?php

$doc->addScriptApplySelector('#'.$id_by_name,'field_editor',array(
    "input_name"=>  $customize->field_name,
    "editor_type"=>$editor_type
),'admin_woopanel/app/HtmlCustomField/hmtl/editor/jquery.editor.js');
