<?php

use WpBookingPro\Factory;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
$open_source=Factory::getOpenSource(1);
$product=$open_source->getEcommerce()->get_product($item->open_source_link_id);
?>
<div class="wrapper-service-item" data-category_id="<?php echo (esc_attr($item->category_id)) ?>"
     data-id="<?php echo (esc_attr($item->id)) ?>">
    <?php echo (HtmlBackend::render_checkbox($item->id)) ?>
    <div class="wrapper-service-content">
        <div class="row">
            <div class="col-md-4">
                <div class="service-item-content ">
                    <span class="name"><?php echo (esc_html($item->name)) ?></span>
                    <span class="link-product">
						<?php if ($item->open_source_link_id && $product) { ?>
                            <a target="_blank"
                               href="<?php echo (esc_attr(get_permalink($item->open_source_link_id)))  ?>"><?php echo (esc_html($product->get_name())); ?></a>
						<?php } else { ?>
							<?php esc_html_e('No link open source item','wpbookingpro') ?>
						<?php } ?>
                    </span>
                </div>
            </div>
            <div class="col-md-2">
                <div class="img-box">
                    <div>
                        <img class="service-image" src="<?php echo (esc_attr(Factory::getRootUrlPlugin())) ?><?php echo (esc_attr($item->image)) ?>" alt="service-image" />
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item">
                    <span><?php esc_html_e('Duration','wpbookingpro') ?>:</span>
                    <span class="duration"><?php printf("%s hours 30 minutes", floor($item->duration)); ?></span>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item">
                    <span><?php esc_html_e('Price','wpbookingpro') ?>:</span>
                    <span class="price"><?php echo(HtmlBackend::render_price($item->price)) ?></span>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="wrapper-button">
                    <a href="<?php echo(UtilityAlias::getBackendGoToLink("service.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
                    <a href="<?php echo(UtilityAlias::goToTaskByView("service","service.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>
