<?php
use WpBookingPro\Utilities\Utility as UtilityAlias;
$item = $this->item;
?>
<div class="wrapper-category-item <?php echo (esc_attr($this->index_category == 0 ? ' active ' : '')) ?> "
     data-id="<?php echo (esc_attr($item->id)); ?>" data-ordering="<?php echo (esc_attr($item->ordering)); ?>"
     href="#tab-category-<?php echo (esc_attr($item->id)); ?>"
     aria-controls="tab-category-<?php echo (esc_attr($item->id)); ?>" role="tab" data-toggle="tab">
    <div class="wrapper-category-content">
        <div class="header">
            <div class="row">
                <div class="col-md-12">
                    <div class="category-item-content">
                        <div class="pull-left"><i class="menu-icon flaticon-menu-1"></i></div>
                        <div class="category-item-content pull-left">
                            <div class="name"><?php echo (esc_html($item->name)); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="body">
            <div class="row">
                <div class="col-md-12">
                    <div class="wrapper-body">
                        <div class="pull-left">
                            <span class="label label-info"><?php printf('%s Services', count((array)$item->list_service)) ?></span>
                        </div>
                        <div class="pull-right wrapper-button-category">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("category.form",array("id"=>$item->id))) ?>" class="btn-category-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>">
                                <i class="far fa-edit"></i>
                            </a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("category",'category.delete',array("id"=>$item->id))) ?>" class="btn-category-remove" title="<?php esc_attr_e('Delete','wpbookingpro')?>">
                                <i class="far fa-trash-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
