<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
WpBookingProHtmlBackendAlias::load_jquery_library('ui');
WpBookingProHtmlBackendAlias::load_jquery_library('content_edit_table');
ToolBar::setTitle("List service");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
ob_start();
$this->loadTemplate('list_service_item');
$html_service_item = ob_get_clean();
ob_start();
$this->loadTemplate('list_category_item');
$html_category_item = ob_get_clean();
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("service.form")) ?>" name="admin-form" method="post">
        <div class="view-list-service">
            <div class="list-service-service main-table">
                <div class="row">
                    <div class="col-md-4">
                        <h4><?php esc_html_e('All categories','wpbookingpro') ?></h4>
                        <div class="list-category nav nav-tabs" role="tablist">
                            <?php foreach ($this->list_service_by_category as $index_category=>  $category) { ?>
                                <?php $this->item=$category ?>
                                <?php $this->index_category=$index_category ?>
                                <?php  $this->loadTemplate('list_category_item') ?>
                            <?php } ?>
                        </div>
                        <a class="btn btn-primary btn-block btn-add-category" href="<?php echo(UtilityAlias::goToTaskByView("category","category.add")) ?>"><i class="far fa-plus-square"></i><?php esc_attr_e('Add category','wpbookingpro') ?></a>
                    </div>
                    <div class="col-md-8">
                        <h4><?php esc_html_e('All services','wpbookingpro') ?></h4>
                        <div class="wrapper-list-service-by-category tab-content">
                            <?php foreach ($this->list_service_by_category as $index_category => $category) { ?>
                                <div class="list-service-by-category tab-pane <?php echo (esc_attr($index_category == 0 ? ' active ' : null)) ?>"
                                     role="tabpanel" id="tab-category-<?php echo (esc_attr($category->id)); ?>"
                                     data-category_id="<?php echo (esc_attr($category->id)); ?>">
                                    <?php foreach ($category->list_service as $service) { ?>
                                        <?php $this->item=$service ?>
                                        <?php  $this->loadTemplate('list_service_item') ?>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_service.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-service', 'view_list_service', array(
    "list_service_by_category"=>  $this->list_service_by_category,
    "html_service_item"=>  $html_service_item,
    "html_category_item"=>  $html_category_item,
), "admin/app/assets/js/view_list_service.js");
?>