<?php

namespace WpBookingProAdmin\app\views\service;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\CustomizeHelper;

class ServiceView extends View
{
    public function display($tpl)
    {
        $modelservice = Model::getInstance("service");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("service.add");
                ToolBar::delete("service.delete_list");
                ToolBar::_clone("service.clone_list");
                $model = Model::getInstance("services");
                $this->list = $model->getList();
                $this->list_service_by_category = $model->getListServiceCategory();
                break;
            case "form":
                ToolBar::setTitle('Edit service');
                ToolBar::apply("service.apply");
                ToolBar::save("service.save");
                ToolBar::cancel("service.cancel");
                ToolBar::back_to_list("service.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelservice->getItem($id);
                $this->form = $modelservice->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("service");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);

                break;
        }
        return parent::display($tpl);
    }
}