<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List review");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("review.form")) ?>" name="admin-form" method="post">
        <div class="view-list-review">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Email','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Title','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Rating','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Comments','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="email nowrap"><?php echo (esc_html($item->email)); ?></td>
                        <td class="title nowrap"><?php echo (esc_html($item->title)); ?></td>
                        <td class="rating nowrap"><?php echo (esc_html($item->avg_rating)); ?></td>
                        <td class="comments nowrap"><?php echo (esc_html($item->comments)); ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public', 'wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public', 'wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="review-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("review.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("review","review.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_review.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-review', 'view_list_review', array(

), "admin/app/assets/js/view_list_review.js");
?>