<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List order status");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("orderstatus.form")) ?>" name="admin-form" method="post">
        <div class="view-list-orderstatus">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookingpro'); ?></th>
                        <th class="name-order-status nowrap"><?php esc_html_e('Name','wpbookingpro') ?></th>
                        <th class="id-order-status nowrap"><?php esc_html_e('ID','wpbookingpro') ?></th>
                        <th class="ordering-order-status nowrap"><?php esc_html_e('Ordering','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="ordering nowrap"><?php echo (esc_html($item->ordering)); ?></td>
                        <td class="orderstatus-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("orderstatus.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("orderstatus","orderstatus.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_orderstatus.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-orderstatus', 'view_list_orderstatus', array(

), "admin/app/assets/js/view_list_orderstatus.js");
?>