<?php
use WpBookingPro\Language\Text;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;

WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
$item = $this->item;
$doc = FactoryAlias::getDocument();
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>
<div class="view-orderpackage-form">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">
        <table id="example" class="display table"">
            <?php if(count($item->list_order_package))  { ?>
                <thead>
                <tr class="list-rate-info list-rate-info-<?php echo (esc_attr($item->id)); ?>">
                    <th class="nowrap"><?php esc_html_e('Start time','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_html_e('End time','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_html_e('Assigned to','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_html_e('Service','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_html_e('Duration','wpbookingpro') ?></th>
                    <th class="nowrap"><?php esc_html_e('Location','wpbookingpro') ?></th>
                </tr>
                </thead>
                <tbody>
                    <?php foreach ($item->list_order_package as $order_package) { ?>
                        <tr class="list-rate-info">
                            <td class="nowrap">
                                <?php echo (esc_html(HtmlBackend::render_date($order_package->rate->start_date,"H:i"))); ?>
                            </td>
                            <td class="nowrap">
                                <?php echo (esc_html(HtmlBackend::render_date($order_package->rate->end_date,"H:i"))); ?>
                            </td>
                            <td class="nowrap">
                                <div class="img-box">
                                    <img class="employee-item-image pull-left" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin() . $order_detail->employee_image))  ?>" alt="employee-item-image" />
                                </div>
                                <h4 class="pull-left employee-item-name"><?php echo (esc_html($order_package->employee_full_name)); ?></h4>
                            </td>
                            <td class="nowrap"><?php echo (esc_html($order_package->service_name)); ?></td>
                            <td class="nowrap"><?php echo (esc_html($order_package->rate->duration)) ?></td>
                            <td class="nowrap"><?php echo (esc_html($order_package->location_address)); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            <?php }?>
        </table>
    </form>
</div>
<?php
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/list_form_orderpackage.less');
$doc->addScriptApplySelector('.view-orderpackage-form', 'list_view_order_package', array(

), "admin/app/assets/js/list_view_order_package.js");
?>
