<?php

use WpBookingPro\Factory;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
?>
<div class="wrapper-employee-item" data-employee_id="<?php echo (esc_attr($item->id)); ?>">
    <?php echo (HtmlBackend::render_checkbox($item->id)) ?>
    <div class="wrapper-employee-content">
        <div class="employee-item-image pull-left">
            <div>
                <img class="image-cover" src="<?php echo (esc_attr(Factory::getRootUrlPlugin())) ?><?php echo (esc_attr($item->cover == null) ? 'admin/app/assets/images/no-image.jpg' : $item->cover) ?>" alt="employee-item-image" />
            </div>
        </div>
        <div class="employee-item-content pull-left">
            <p><label class="name"><?php echo (esc_html(ucwords($item->full_name))) ?></label></p>
            <p><label class="email"><?php echo (esc_html($item->email)); ?></label></p>
            <p>
                <label class="mobile">
                    <?php
                    $mobile = isset($item->mobile)?$item->mobile:'';
                    if(trim($mobile)!= '' && $mobile['0'] == 0) {
                        $mobile = substr($mobile,1);
                    }
                    $phonecode = isset($item->phonecode)?$item->phonecode:'';
                    echo (esc_html('+'.$phonecode . $mobile));
                    ?>
                </label>
            </p>
        </div>
    </div>
    <div class="employee-action">
        <?php if ($item->published == 1) { ?>
            <div class="away">
                <p><?php esc_attr_e('Away','wpbookingpro') ?></p>
            </div>
        <?php } else { ?>
            <div class="away">
                <p><?php esc_attr_e('Offline','wpbookingpro') ?></p>
            </div>
        <?php } ?>
        <a class="btn btn-primary btn-edit" href="<?php echo(UtilityAlias::getBackendGoToLink("employee.form",array("id"=>$item->id))) ?>" >
            <i class="fas fa-edit"></i>
            <?php esc_html_e('Edit','wpbookingpro')?>
        </a>
    </div>
</div>
