<?php

namespace WpBookingProAdmin\app\views\customer;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class CustomerView extends View
{
    public function display($tpl)
    {
        $modelCustomer = Model::getInstance("customer");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("customer.add");
                ToolBar::delete("customer.delete_list");
                ToolBar::_clone("customer.clone_list");
                $model = Model::getInstance("customers");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Customer');
                ToolBar::apply("customer.apply");
                ToolBar::save("customer.save");
                ToolBar::cancel("customer.cancel");
                ToolBar::back_to_list("customer.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelCustomer->getItem($id);
                $this->form = $modelCustomer->getForm();
                break;
        }
        return parent::display($tpl);
    }
}