<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List category");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("category.form")) ?>" name="admin-form" method="post">
        <div class="view-list-category">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Image','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Access','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Language','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Id','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <img class="category-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin()))  ?>/<?php echo (esc_attr($item->image)); ?>" alt="category-image"/>
                            </div>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="nowrap"><?php esc_html_e('All','wpbookingpro')?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="state-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("category.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView("category","category.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_category.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-category', 'view_list_category', array(

), "admin/app/assets/js/view_list_category.js");
?>