<?php

namespace WpBookingProAdmin\app\views\category;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class CategoryView extends View
{
    public function display($tpl)
    {
        $modelcategory = Model::getInstance("category");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("category.add");
                ToolBar::delete("category.delete_list");
                ToolBar::_clone("category.clone_list");
                $model = Model::getInstance("category");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit category');
                ToolBar::apply("category.apply");
                ToolBar::save("category.save");
                ToolBar::cancel("category.cancel");
                ToolBar::back_to_list("category.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelcategory->getItem($id);
                $this->form = $modelcategory->getForm();
                break;
        }
        return parent::display($tpl);
    }
}