<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('moment');
WpBookingProHtmlBackendAlias::load_jquery_library('fullcalendar');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
ToolBar::setTitle("Calendar");
$list_employee = $this->list_employee;
?>
<?php ?>
    <div class="view-list-calendar">
        <div class="wrapper-employee">
            <ul class="list-employee">
                <li class="employee-item active" data-employee_id="0">
                    <div class="wrapper-img">
                        <div class="block-image">
                            <span><?php esc_html_e('All', 'wpbookingpro');?></span>
                        </div>
                    </div>
                    <p class="text"><?php esc_html_e('All employees', 'wpbookingpro');?></p>
                </li>
                <?php foreach ($list_employee as $employee) {?>
                    <li class="employee-item" data-employee_id="<?php echo (esc_attr($employee->id));?>">
                        <div class="wrapper-img">
                            <div class="img-box">
                                <div>
                                    <img src="<?php echo(FactoryAlias::getRootUrlPlugin())?><?php echo (esc_attr($employee->cover));?>" alt="employee-cover">
                                </div>
                            </div>
                        </div>
                        <p class="employee-name" title="<?php echo(esc_html($employee->first_name.' '.$employee->last_name));?>">
                            <?php echo(esc_html($employee->first_name.' '.$employee->last_name));?>
                        </p>
                    </li>
                <?php }?>
            </ul>
        </div>
        <div id="calendar"></div>
        <div id="calendarModal" class="modal fade" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span> <span class="sr-only"><?php esc_html_e('Close','wpbookingevent') ?></span></button>
                        <h4 id="modalTitle" class="modal-title"><?php esc_html_e('Edit Event','wpbookingevent') ?></h4>
                    </div>
                    <div id="modalBody" class="modal-body">
                        <form  action="<?php echo(UtilityAlias::getBackendGoToLink("calendar.list")) ?>"  method="post" id="changeform" role="form" name="client-form" enctype="multipart/form-data">
                            <?php
                                $field = $this->form->getField('calendar');
                                echo ($field->input);
                            ?>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal" ><?php esc_html_e('Close','wpbookingevent') ?></button>
                        <button type="submit" id="btnRemoveIt" class="btn btn-danger" data-dismiss="modal" ><?php esc_html_e('Remove','wpbookingevent') ?></button>
                        <button type="submit" id="btnSaveIt" class="btn btn-success" data-dismiss="modal" ><?php esc_html_e('Add Event','wpbookingevent') ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_calendar.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-calendar','view_list_calendar',array(
    "list_order"=>  $this->list,
    "list_service"=>$this->list_service
),'admin/app/assets/js/view_list_calendar.js');
?>