<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class ServicesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "services";
    /**
     * @var string
     */
    public $table_name = "service";

    public function getListServiceCategory()
    {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $modelCategories = Model::getInstance('categories');
        $list_service_category = $modelCategories->getList();
        foreach ($list_service_category as &$category) {
            $query->clear()
                ->select('service.*')
                ->from($this->getTableName('service') . ' AS service')
                ->where('category_id=' . $category->id)
                ->order('ordering');
            $category->list_service = $db->setQuery($query)->loadObjectList();
            $query->clear()
                ->select('extra.*')
                ->from($this->getTableName('extra') . ' AS extra')
                ->where('object_id=' . $category->id)
                ->where('type=' . $query->quote('service'));
            $category->extra = $db->setQuery($query)->loadObjectList();
        }
        return $list_service_category;
    }
    public function sorting($list)
    {
        foreach ($list as $item){
            $item=(object)$item;
            $item_sorting=[
                'id'=> $item->id,
                'ordering'=>$item->ordering
            ];
            if(!parent::save($item_sorting)){
                return false;
            }
        }
        return true;
    }

}
