<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdmin\app\Html\HtmlBackend;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";

    public function getItem($id = 0)
    {
        if(isset($id) && $id > 0) {
            $item = (object)parent::getItem($id); // TODO: Change the autogenerated stub
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('customer.*')
                ->from($this->getTableName('customer') . ' AS customer')
                ->where('customer.id=' . (int)$item->customer_id);
            $item->customer = $this->db->setQuery($query)->loadObjectList();
            $item->customer_full_name = $item->customer[0]->first_name .' '.$item->customer[0]->last_name;
            $query->clear()
                ->select("order_detail.*")
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->where('order_detail.order_id=' . (int)$id);
            $item->list_order_detail = $this->db->setQuery($query)->loadObjectList();
            $list_rate=[];
            foreach ($item->list_order_detail as $order_detail) {
                $query->clear()
                    ->select("order_detail_rate.*")
                    ->from($this->getTableName('order_detail_rate') . ' AS order_detail_rate')
                    ->leftJoin($this->getTableName('service') . ' AS service ON service.id=order_detail_rate.service_id')
                    ->select('service.name as service_name,service.price as service_price,service.image as service_image')
                    ->leftJoin($this->getTableName('location') . ' AS location  ON location.id=order_detail_rate.location_id')
                    ->select('location.address AS location_address')
                    ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=order_detail_rate.employee_id')
                    ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.cover AS employee_cover')
                    ->where('order_detail_id=' . (int)$order_detail->id);
                $list_rate = $this->db->setQuery($query)->loadObjectList();
                foreach ($list_rate as &$rate) {
                    $start_date = Factory::getDate($rate->start_date);
                    $end_date = Factory::getDate($rate->end_date);
                    $since_start = $start_date->diff($end_date);
                    $rate->duration = $since_start->h. ' hours '. $since_start->i. ' minutes';
                    /////////////////////
                    $startDate = HtmlBackend::render_date($rate->start_date,'Y-m-d');
                    $endDate = HtmlBackend::render_date($rate->end_date,'Y-m-d');
                    $startTime = HtmlBackend::render_date($rate->start_date,'H:i');
                    $endTime = HtmlBackend::render_date($rate->end_date,'H:i');
                    $rate->list_date_detail = ($start_date == $end_date) ? $startDate : $startDate . ' - ' . $endDate;
                    $rate->list_time_detail = $startTime . ' - ' . $endTime;
                    $rate->employee_fullname = $rate->employee_first_name.' '.$rate->employee_last_name;
                }
                $order_detail->rate = $list_rate;
            }
            $item->list_rate = $list_rate;
            return $item;
        }

    }
    public function change_order_status($data=array())
    {
        $data_order = array(
            "id" => $data['order_id'],
            "open_source_order_status_id" => $data['open_source_order_status_id']
        );
        $order = parent::save($data_order);
        return $order;
    }


}
