<?php
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('select_yes_no');
WpBookingProHtmlBackendAlias::load_jquery_library('tooltipster');


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-yesno-<?php echo (esc_attr($name_of_field)) ?> field-yesno">
        <div class="form-control">
                <div class="block-left">
                    <label><?php echo (esc_html($label)) ?></label>
                    <span class="tooltipster" class="fas fa-question-circle"></span>
                </div>
                <div class="block-right">
                    <input class="form-check-input yes-no pull-right" <?php echo (esc_attr($value == 1 ? ' checked ' : "unchecked")) ?>
                           type="checkbox">
                    <input class="" name="<?php echo (esc_attr($name)); ?>" type="hidden"
                           value="<?php echo (esc_attr($value)) ?>">
                </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/yesno/yesno.less');
$doc->addScriptApplySelector('#'.$id_by_name,'field_yesno',array(
    "field_name"=>  $name,
), 'admin/app/layouts/WooBooking/form/field/yesno/yesno.jquery.js');