<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackend::load_jquery_library('ui');
WpBookingProHtmlBackend::load_jquery_library('select2');
WpBookingProHtmlBackend::load_jquery_library('fontawesome');
WpBookingProHtmlBackend::load_jquery_library('moment');
WpBookingProHtmlBackend::load_jquery_library('daterangepicker');


$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/rate/rate.less');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
if(count((array)$value) > 0 && isset($value['0'])) {
    $list_rate = (array)$value;
} else {
    $list_rate = array();
}

$template_range_date = function ($name, $from, $to, $required) {
    $from = Factory::getDate($from);
    if (!$from->getTimestamp()) {
        $from = clone Factory::getDate();
    }
    $from = $from->toSql();
    $to = Factory::getDate($to);
    if (!$to->getTimestamp()) {
        $to = clone Factory::getDate();
    }
    $to = $to->toSql();
    ob_start();
    ?>
    <div class="item">
        <div class="input-rate">
            <input type="text" class="form-control m-input rate"
                   value="<?php echo (esc_attr($from && $to ? "$from;$to" : '')) ?>"/>
        </div>
        <div class="controllers">
            <button type="button" class="btn btn-primary btn-add "><i class="far fa-copy"></i>
            </button>
            <button type="button" class="btn btn-danger btn-close-item"><i
                        class="far fa-trash-alt"></i></button>
        </div>
        <input type="hidden" class="rates" required="<?php echo (esc_attr($required)) ?>"
               value="<?php echo (esc_attr($from && $to ? "$from;$to" : '')) ?>"
               name="<?php echo (esc_attr($name)); ?>[]">
    </div>
    <?php
    return ob_get_clean();
};
$item_rate = '';
$max_rate = isset($max_rate) ? $max_rate : 10
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-input-rate">
        <div class="list-item">
            <?php if (count($list_rate) == 0) {
                echo($template_range_date($name, null, null, $required));
            } else { ?>
                <?php foreach ($list_rate as $key => $rate) {
                    echo($template_range_date($name, $rate->from, $rate->to, $required));
                } ?>
            <?php } ?>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.field-input-rate', 'field_rate', array(
    "item_rate" => $template_range_date($name, "", "", $required),
    "input_name" => $name . '[]',
    "max_rate" => $max_rate,
    "values" => $value,
), 'admin/app/layouts/WooBooking/form/field/rate/rate.jquery.js');
