<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list = get_pages();
$list_time = [];
$list_page_id = [];
if (!is_array($value)) {
	$list_page_id[] = $value;
} else {
	$list_page_id = $value;
}



?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-pages">
        <select class="list-page" required="<?php echo (esc_attr($required)) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> >
            <option value=""><?php esc_html_e('Select page','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->ID, $list_page_id) ? ' selected ' : null) ?>
                        value="<?php echo (esc_attr($item->ID)); ?>"><?php echo (esc_html($item->post_title)); ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/pages/pages.less');
$doc->addScriptApplySelector("#$id_by_name",'field_pages',array(
        'input_name'=> $name,
        'value'=> $value
),'admin/app/layouts/WooBooking/form/field/pages/pages.jquery.js');