"use strict";
(function ($) {
    $.field_opendate = function (element, options) {
        var defaults = {
            input_name:'',
            open_date:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let now = new Date;
            let open_date = plugin.settings.open_date;
            $element.find(`input[name="${plugin.settings.input_name['0']}"]`).val(open_date);
            $element.find('input[id="open-date"]#open-date').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                timePicker: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD HH:mm:ss'
                },
                maxYear: '+10',
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name['0']}"]`).val(start.format('YYYY-MM-DD HH:mm:ss'));
            });
            $element.find('.label').on('click',function (e) {
                if (!$(this).find('input[type="checkbox"]').is(':checked')) {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                } else {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                }
            });
            $element.find('input[type="checkbox"]#opendate-ckb').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '10%'
            }).on('ifChanged ', function(event) {
                if (!$(this).is(':checked')) {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');

                } else {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                }
            });
            $element.find('input[type="checkbox"]#opendate-ckb').on('ifChecked', function () {
                $element.find(`input[name="${plugin.settings.input_name['0']}"]`).val(moment(now).format('YYYY-MM-DD HH:mm:ss'))
            })
            $element.find('input[type="checkbox"]#opendate-ckb').on('ifUnchecked', function () {
                $element.find(`input[name="${plugin.settings.input_name['0']}"]`).val(open_date)
            })
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.field_opendate = function (options) {
        return this.each(function () {
            
            if (undefined == $(this).data('field_opendate')) {
                var plugin = new $.field_opendate(this, options);
                $(this).data('field_opendate', plugin);
            }
        });
    }
})(jQuery);