<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-bookingstyle">
        <select class="list-bookingstyle" >
            <option value=""><?php esc_html_e('Select booking style','wpbookingpro') ?></option>
            <option <?php echo (($value == "in_line") ? ' selected ' : null) ?> value="in_line">
                <?php esc_html_e('Booking in line','wpbookingpro') ?>
            </option>
            <option <?php echo (($value == "integrate") ? ' selected ' : null) ?> value="integrate" >
                <?php esc_html_e('Integrate','wpbookingpro') ?>
            </option>
        </select>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>" >
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/bookingstyle/bookingstyle.less');
$doc->addScriptApplySelector('.field-bookingstyle','field_bookingstyle',array(
    'input_name'=> $name,
    'value'=>$value
),'admin/app/layouts/WooBooking/form/field/bookingstyle/bookingstyle.jquery.js');