"use strict";
(function ($) {
    $.view_form_event = function (element, options) {
        let defaults = {
            row_state_template: "",
            list_employee:[]
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let arr = [];
            $element.find('input[name="rates[]"]').on('change', function () {
                let rates = $(this).val();
                rates = rates.split(';');
                for(let i = 0; i < rates.length;i++) {
                    arr.push(rates[i]);
                }
                let min = plugin.getMinValueInArray(arr);
                $element.find('input#closedate-ckb').on('ifChecked', function () {
                    $element.find('input[name="close_date"]').val(min)
                })
            });
            let $service_select = $element.find('select[name="service_id"]');
            let list_employee = [];
            $service_select.on('change', function () {
                $element.find('select[name="list_employee_id[]"]').val([]).trigger('change');
                let service_id = $(this).val();
                let data = {
                    service_id: service_id,
                    task: "service.ajax_get_list_employee"
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        list_employee = response.data;
                        let $employee_option = $element.find('select[name="list_employee_id[]"] option');
                        $employee_option.each(function (index, item) {
                            let val = item.value;
                            item.disabled = true;
                            list_employee.map(function (employee) {
                                if(val === employee) {
                                    item.disabled = false;
                                }
                            });

                        });
                    }
                });
            })
        };
        plugin.getMinValueInArray = function (arr ) {
            let min = arr[0];
            for (let i = 0; i < arr.length; i++) {
                if(new Date(min).getTime() > new Date(arr[i]).getTime()) {
                    min = arr[i]
                }
            }
            return min;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_form_event = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_form_event')) {
                let plugin = new $.view_form_event(this, options);
                $(this).data('view_form_event'
                    , plugin);
            }
        });
    }
})(jQuery);
