"use strict";
(function ($) {
    $.list_view_appointment = function (element, options) {
        let defaults = {
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.change_status_order = function (order_id, open_source_order_status_id) {
            let data = {
                order_id: order_id,
                open_source_order_status_id: open_source_order_status_id,
                task: "appointment.ajax_change_order_status"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('#example').DataTable({
                drawCallback: function () {
                    $element.find('.order-status').select2();
                    $element.find('input[type="checkbox"]').iCheck({
                        checkboxClass: 'icheckbox_square-red',
                        radioClass: 'iradio_square-red',
                        increaseArea: '10%'
                    });
                }
            });
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.order-status').select2(
                {containerCssClass: "order-status"}
            );
            $element.find('.order-status').on('change',function (e) {
                let $tr = $(this).closest('.row-item-order');
                let order_id = $tr.data('order_id');
                let open_source_order_status_id = $(this).val();
                plugin.change_status_order(order_id, open_source_order_status_id);
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };
    $.fn.list_view_appointment = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('list_view_appointment')) {
                let plugin = new $.list_view_appointment(this, options);
                $(this).data('list_view_appointment', plugin);
            }
        });
    }
})(jQuery);
