<?php
function Netbase_Load_Social_Links_Widget()
{
    register_widget( 'NB_Widgets_Social_Links');
}
add_action( 'widgets_init', 'Netbase_Load_Social_Links_Widget' );

class NB_Widgets_Social_Links extends WP_Widget {
	protected $default;
	protected $socials;

	function __construct() {
		$this->socials = array(
			'facebook'    => esc_html__( 'Facebook', 'aidoo-elements' ),
			'twitter'     => esc_html__( 'Twitter', 'aidoo-elements' ),
			'linkedin'    => esc_html__( 'Linkedin', 'aidoo-elements' ),
			'google-plus' => esc_html__( 'Google Plus', 'aidoo-elements' ),
			'pinterest'   => esc_html__( 'Pinterest', 'aidoo-elements' ),
			'tumblr'      => esc_html__( 'Tumblr', 'aidoo-elements' ),
			'instagram'   => esc_html__( 'Instagram', 'aidoo-elements' ),
			'youtube'     => esc_html__( 'Youtube', 'aidoo-elements' ),
			'dribbble'    => esc_html__( 'Dribbble', 'aidoo-elements' ),
		);
		$this->default = array(
			'title' => '',
		);
		foreach ( $this->socials as $k => $v ) {
			$this->default["{$k}_title"] = '';
			$this->default["{$k}_url"]   = '';
		}

		parent::__construct(
			'nbelement-social-links-widget',
			esc_html__( 'NB - Social Links', 'aidoo-elements' ),
			array(
				'classname'   => 'nbfw-social-links widget__social-link',
				'description' => esc_html__( 'Display links to social media networks.', 'aidoo-elements' ),
			)
		);
	}

	/**
	 * Outputs the HTML for this widget.
	 *
	 * @param array $args An array of standard parameters for widgets in this theme
	 * @param array $instance An array of settings for this widget instance
	 *
	 * @return void Echoes it's output
	 */
	function widget( $args, $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		extract( $args );
		
		echo wp_kses_post( $before_widget );

		if ( $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) ) {
			echo wp_kses_post( $before_title . $title . $after_title );
		}
		$icon_style 	= $instance['icon_style'];
		$border_style 	= $instance['border_style'];
		$colorful_bg 	= $instance['colorful_bg'] == 'yes' ? 'colorful_bg' : '';
		$icon_size 		= trim($instance['icon_size']);
		$align 			= 'align-' . $instance['align'];
		$border_style_class = $instance['icon_style'] == 'square-icon' ? '-square' : '';
		$icon_size_inline_css = " style='font-size:" . $icon_size . "px'";

		echo '<ul class="nbfw-social-link-widget ' . $icon_style . ' ' . $align . ' ' . $border_style . ' ' . $colorful_bg . '">';
		foreach ( $this->socials as $social => $label ) {
			if ( ! empty( $instance[ $social . '_title' ] ) || ! empty( $instance[ $social . '_url' ] ) ) {
				printf( '<li><a href="%1$s" rel="nofollow" class="nb-icon-%6$s" title="%2$s"><i class="nb-ss-icon-%3$s%4$s"%5$s></i></a></li>',
					$instance[ $social . '_url' ],
					$instance[ $social . '_title' ],
					$social,
					$border_style_class,
					$icon_size_inline_css,
					$social
				);
			}
		}
		echo '</ul>';

		echo wp_kses_post( $after_widget);
	}


	/**
	 * Deals with the settings when they are saved by the admin.
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	/**
	 * Displays the form for this widget on the Widgets page of the WP Admin area.
	 *
	 * @param array $instance
	 *
	 * @return array
	 */
	function form( $instance ) {
		$instance = wp_parse_args( $instance, $this->default );

		$icon_style				= isset( $instance[ 'icon_style' ] ) ? $instance[ 'icon_style' ] : 'regular-icon';
		$icon_size				= isset( $instance[ 'icon_size' ] ) ? $instance[ 'icon_size' ] : '18';
		$align					= isset( $instance[ 'align' ] ) ? $instance[ 'align' ] : 'left';
		$border_style			= isset( $instance[ 'border_style' ] ) ? $instance[ 'border_style' ] : 'no-border';
		$colorful_bg			= isset( $instance[ 'colorful_bg' ] ) ? $instance[ 'colorful_bg' ] : 'no';
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'aidoo-elements' ); ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
		</p>

		<?php

		$html = '';
		// Icon Style
		$icon_style_regular	= $icon_style == 'regular-icon' ? 'selected="selected"' : '';
		$icon_style_square	= $icon_style == 'square-icon' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Icon Style', 'aidoo-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'icon_style' ) . '">
						<option value="regular-icon"' . $icon_style_regular . '>' . esc_html__( 'Regular', 'aidoo-elements' ) . '</option>
						<option value="square-icon"' . $icon_style_square . '>' . esc_html__( 'Square', 'aidoo-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Icon Size

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Icon Size', 'aidoo-elements' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'icon_size' ) . '" value="' . $icon_size . '"/>';
		$html  .= '</p>';

		// Shape Style
		$border_style_none 	= $border_style == 'no-border' ? 'selected="selected"' : '';
		$border_style_circle = $border_style == 'circle-border' ? 'selected="selected"' : '';
		$border_style_square = $border_style == 'square-border' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Border Style', 'aidoo-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'border_style' ) . '">
						<option value="no-border"' . $border_style_none . '>' . esc_html__( 'None', 'aidoo-elements' ) . '</option>
						<option value="circle-border"' . $border_style_circle . '>' . esc_html__( 'Circle', 'aidoo-elements' ) . '</option>
						<option value="square-border"' . $border_style_square . '>' . esc_html__( 'Square', 'aidoo-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Colorful Background
		$colorful_bg_yes 					= $colorful_bg == 'yes' ? 'selected="selected"' : '';
		$colorful_bg_no 					= $colorful_bg == 'no' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Colorful Background', 'aidoo-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'colorful_bg' ) . '">
						<option value="no"' . $colorful_bg_no . '>' . esc_html__( 'No', 'aidoo-elements' ) . '</option>
						<option value="yes"' . $colorful_bg_yes . '>' . esc_html__( 'Yes', 'aidoo-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';


		// Align
		$align_left 					= $align == 'left' ? 'selected="selected"' : '';
		$align_center 					= $align == 'center' ? 'selected="selected"' : '';
		$align_right 					= $align == 'right' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Align', 'aidoo-elements' ) . ': </label>';
		$html  .= '<select class="widefat" name="' . $this->get_field_name( 'align' ) . '">
						<option value="left"' . $align_left . '>' . esc_html__( 'Left', 'aidoo-elements' ) . '</option>
						<option value="center"' . $align_center . '>' . esc_html__( 'Center', 'aidoo-elements' ) . '</option>
						<option value="right"' . $align_right . '>' . esc_html__( 'Right', 'aidoo-elements' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		echo $html;
		?>

		
		<?php
		foreach ( $this->socials as $social => $label ) {
			printf(
				'<div>
					<label>%s</label>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
					<p><input type="text" class="widefat" name="%s" placeholder="%s" value="%s"></p>
				</div>',
				$label,
				esc_attr( $this->get_field_name( $social . '_title' ) ),
				esc_html__( 'Title', 'aidoo-elements' ),
				esc_attr( $instance[ $social . '_title' ] ),
				esc_attr( $this->get_field_name( $social . '_url' ) ),
				esc_html__( 'URL', 'aidoo-elements' ),
				esc_url( $instance[ $social . '_url' ] )
			);
		}
	}
}
