<?php
/*
Plugin Name: Retreatclub Elements
Plugin URI: http://netbaseteam.com/
Description: Prodive all Elementor elements and widgets.
Version: 1.0.0
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
*/

define('TP_ELEMENTS_PATH', plugin_dir_path(__FILE__));
define('TP_ELEMENTS_NAME', plugin_basename(__FILE__));
define('TP_ELEMENTS_URL', plugin_dir_url( __FILE__ ));

class Netbase_Elements
{
    public static function init()
    {
        self::include_function_plugins();
        self::load_widget();
        add_action('wp_enqueue_scripts', array(__CLASS__, 'nb_elements_enqueue_scripts'));
        add_action( 'elementor/widgets/widgets_registered', [ __CLASS__, 'register_widgets' ] );
        add_action( 'elementor/elements/categories_registered', [ __CLASS__, 'add_elementor_widget_categories' ] );
        add_shortcode( 'nb-search-form', [ __CLASS__, 'nb_search_form' ] );
        add_shortcode( 'nb-user-form', [ __CLASS__, 'nb_user_form' ] );
        add_shortcode('nb-singup-register', [__CLASS__,'nb_singup_register'] );
        add_shortcode('nb-link-login', [__CLASS__,'nb_link_login'] );
    }
    public static function nb_link_login() {
        ob_start();
        if( is_user_logged_in() ) {
            echo '<div class="login-pc">';
            echo '<a href="'.site_url().'/sellercenter/wb_dashboard/"><span class="icon-speedometer-2"></span>'.esc_html__('Dashboard', 'retreatclub').'</a>';
            echo '</div>';
        }else {
            echo '<div class="login-pc">';
            echo '<a href="javascript:;"><span class="icon-login"></span>'.esc_html__('Login  /  Register', 'retreatclub').'</a>';
            echo '</div>';
        }

        return ob_get_clean();
    }
    public static function nb_search_form() {
        ob_start();
        echo '<div class="search-form-header">';
        echo get_search_form();
        echo '</div>';
        return ob_get_clean();
    }

    public static function nb_user_form() {
        ob_start();
        ?>
        <form class="login-form"  action="/action_page.php">
            <div class="form-group" >
                <a href="" class="btn login-facebook">Login  with Facebook</a>
            </div>
            <div class="form-group">
                <a href="" class="btn login-google">Login  with Google</a>
            </div>
            <div class="or-login">
                <span>or</span>
            </div>
            <div class="form-group icon_email">
                <input type="email" class="form-control email-input" placeholder="Email Address *">
            </div>
            <div class="form-group icon_unlock">
                <input type="password" class="form-control pass-input" placeholder="Password *">
            </div>
             <div class="form-group check-member">
                 <label class="checkbox-inline ">
                     <input type="checkbox" value="" checked>Remember me
                     <span class="checkmark"></span>
                 </label>
                 <a href="" >Forgot Password</a>
             </div>
            <div class="form-group login-btn">
                <a href="" class="btn nb-secondary-button">Login</a>
            </div>
            <div class="txt-login">
                Don’t have an acount ? <a href="">Sign up</a>
            </div>
        </form>
        <?php
        return ob_get_clean();

    }

    public static function nb_elements_enqueue_scripts() {

        wp_enqueue_style( 'swiper', TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '5.3.7');
        wp_enqueue_script( 'swiper',  TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '5.3.7', true);
        
        wp_enqueue_style( 'nb_elements', TP_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
        if(is_rtl()){
            wp_enqueue_style( 'nb_elements_rtl', TP_ELEMENTS_URL . 'assets/rtl.css', array(), '20180324' ); 
        }
        wp_enqueue_script( 'nb_elements', TP_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );


        wp_enqueue_script( 'equal_height', TP_ELEMENTS_URL . 'assets/vendors/jquery-match-height/jquery.matchHeight-min.js', array(), '0.7.2', true );
        wp_enqueue_script( 'imageload', TP_ELEMENTS_URL . 'assets/vendors/imagesloaded/imagesloaded.pkgd.min.js', array(), '4.1.4', true );
        wp_enqueue_script( 'isotope', TP_ELEMENTS_URL . 'assets/vendors/isotope/isotope.pkgd.min.js', array(), '3.0.6', true );

        wp_enqueue_style( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css', array(), '1.1.0' );
        wp_enqueue_script( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array('jquery'), '1.1.0', true );

        wp_enqueue_style( 'nb-socials-share-font-icon', TP_ELEMENTS_URL . 'assets/vendors/fontello/fontello-ss.css', array(), '20200710' );
        wp_localize_script('nb_elements','retreat_elements',array(
            'siteUrl' => site_url(),
        ));
        

    }
    
    public static function include_function_plugins() {

        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    public static function load_widget() {
        require_once( TP_ELEMENTS_PATH . 'widgets/social-links.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/contact-info.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/recent-blog.php' );
    }

    public static function register_widgets() {
		self::include_widgets_files();
    }
    
    public static function include_widgets_files() {
		require_once( TP_ELEMENTS_PATH . 'elementor_widgets/blog/blog.php' );
		require_once( TP_ELEMENTS_PATH . 'elementor_widgets/testimonials/testimonials.php' );
    }
    
    public static function add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'retreatclub-elements',
			[
				'title' => __( 'Retreat Club', 'retreatclub-elements' ),
				'icon' 	=> 'fa fa-plug',
			]
		);
	}

    public static function nb_singup_register($atts = array(), $content = '') {

        $atts = shortcode_atts(array(
            'text' => 'Get the Best Deals for you in Summer Holidays 20% OFF',
            'btn' => 'Get Code',
        ), $atts);

        ob_start(); ?>

        <div class="retreatclub-singup-register">
            <div id="login-register-password">
                <a href="javascript:;" class="close">
                    <span class="icon-close"></span>
                </a>
                <?php global $user_ID, $user_identity; if (!$user_ID) { ?>
                    <div class="tab_container_login">
                        <div id="tab1_login" class="tab_content_login">
                            <div class="title">Login Account</div>
                            <?php do_action( 'nb_before_form_login' ); ?>
                            <form method="post" action="<?php bloginfo('url') ?>/wp-login.php" class="wp-user-form">
                                <div class="username form-group">
                                    <input class="form-control" type="text" name="log" value="" size="20"  tabindex="11" placeholder="<?php _e('Email Address*','retreatclub-elements') ?>" />
                                    <span class="icon-email-login"></span>
                                </div>
                                <div class="password form-group">
                                    <input class="form-control" type="password" name="pwd" value="" size="20" id="user_pass" tabindex="12" placeholder="Password*" />
                                    <span class="icon-unlock"></span>
                                </div>
                                <div class="login_fields">
                                    <div class="rememberme">
                                        <label for="rememberme">
                                            <input type="checkbox" name="rememberme" value="forever" checked="checked" id="rememberme" tabindex="13" /> Remember me
                                            <span class="check-style"></span>
                                        </label>
                                        <a class="lost" href="#tab3_login">Forgot Password</a>
                                    </div>
                                    <?php do_action('login_form'); ?>

                                    <input type="submit" name="user-submit" value="<?php _e('Login'); ?>" tabindex="14" class="user-submit" />
                                    <input type="hidden" name="redirect_to" value="<?php echo site_url().'/sellercenter/wb_dashboard/' ?>" />
                                    <input type="hidden" name="user-cookie" value="1" />
                                    <div class="has-account">
                                        <span>Don’t have an account ?</span>
                                        <a href="#tab2_login">Sign up</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div id="tab2_login" class="tab_content_login" style="display:none;">
                            <div class="title">Register Account</div>
                            <form method="post" action="<?php echo site_url('wp-login.php?action=register', 'login_post') ?>" class="wp-user-form">
                                <div class="username form-group">
                                    <input class="form-control" placeholder="<?php _e('User Name*','retreatclub-elements') ?>" type="text" name="user_login" value="" size="20"  tabindex="101" />
                                    <span class="icon-user"></span>
                                </div>
                                <div class="password form-group">
                                    <input class="form-control" placeholder="<?php _e('Email Address*','retreatclub-elements') ?>" type="text" name="user_email" value="" size="25" id="user_email" tabindex="102" />
                                    <span class="icon-email-login"></span>
                                </div>
                                <div class="login_fields">
                                    <?php do_action('register_form'); ?>
                                    <input type="submit" name="user-submit" value="<?php _e('CREATE ACCOUNT'); ?>" class="user-submit" tabindex="103" />
                                    <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?register=true" />
                                    <input type="hidden" name="user-cookie" value="1" />
                                    <div class="has-account">
                                        <span>Already have an account?</span>
                                        <a href="#tab1_login">Login</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div id="tab3_login" class="tab_content_login" style="display:none;">
                            <div class="title">Forgot Password</div>
                            <form method="post" action="<?php echo site_url('wp-login.php?action=lostpassword', 'login_post') ?>" class="wp-user-form">
                                <div class="username form-group">
                                    <input class="form-control" placeholder="<?php _e('Email Address*','hotelier-elements') ?>" type="text" name="user_login" value="" size="20"  tabindex="1001" />
                                    <span class="icon-email-login"></span>
                                </div>
                                <div class="login_fields">
                                    <?php do_action('login_form', 'resetpass'); ?>
                                    <input type="submit" name="user-submit" value="<?php _e('Send'); ?>" class="user-submit" tabindex="1002" />
                                    <input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>?reset=true" />
                                    <input type="hidden" name="user-cookie" value="1" />
                                    <div class="has-account">
                                        <span>Already have an account?</span>
                                        <a href="#tab1_login">Login</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                <?php } else { // is logged in ?>
                    <div class="sidebox">
                        <h3>Welcome, <?php echo $user_identity; ?></h3>
                        <div class="usericon">
                            <?php global $userdata; echo get_avatar($userdata->ID, 60); ?>
                        </div>
                        <div class="userinfo">
                            <p>You&rsquo;re logged in as <strong><?php echo $user_identity; ?></strong></p>
                            <p>
                                <a href="<?php echo wp_logout_url('index.php'); ?>">Log out</a> |
                                <?php if (current_user_can('manage_options')) {
                                    echo '<a href="' . admin_url() . '">' . __('Admin') . '</a>'; } else {
                                    echo '<a href="' . admin_url() . 'profile.php">' . __('Profile') . '</a>'; } ?>
                            </p>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>

        <?php return ob_get_clean();
    }
}
Netbase_Elements::init();
