<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NB_Testimonials_Elementor extends Widget_Base {

	public function get_name() {
		return 'nb-testimonials-elementor';
	}

	public function get_title() {
		return __( 'Testimonials', 'retreatclub-elements' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'retreatclub-elements' ];
	}

	public function get_script_depends() {
		return [ 'retreatclub-elements' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'retreatclub-elements' ),
			]
		);

		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'retreatclub-elements' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'multiple_column',
				'options' => [
					'multiple_column'  => __( 'Multiple Column', 'retreatclub-elements' ),					
					'sync_thumbnail_content_1' => __( 'Sync Thumbnail and Content 1', 'retreatclub-elements' ),
					'sync_thumbnail_content_2' => __( 'Sync Thumbnail and Content 2', 'retreatclub-elements' ),
				],
			]
		);



		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name',
			[
				'label' => __( 'Name', 'retreatclub-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'position',
			[
				'label' => __( 'Position', 'retreatclub-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'avatar',
			[
				'label' => __( 'Avatar', 'retreatclub-elements' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'retreatclub-elements' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'content',
			[
				'label' => __( 'Content', 'retreatclub-elements' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 10
			]
		);

		$repeater->add_control(
			'comment_date',
			[
				'label' => __( 'Date', 'retreatclub-elements' ),
				'type' => Controls_Manager::DATE_TIME,
				'picker_options' => array('enableTime' => false)
			]
		);

		$this->add_control(
			'testimonial_list',
			[
				'label' => __( 'Testimonial List', 'retreatclub-elements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label' => __( 'Show Pagination', 'retreatclub-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_navigation',
			[
				'label' => __( 'Show Navigation', 'retreatclub-elements' ),
				'type' => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$template_path = TP_ELEMENTS_PATH . '/elementor_widgets/testimonials/template.php';

		require $template_path;
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		?>
		<div class="title">
			{{{ settings.title }}}
		</div>
		<?php
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new NB_Testimonials_Elementor() );