<?php 

$style          = $settings['style'];
$style_class    = 'nb-blog-' . $style;
$excerpt_length = $settings['excerpt_length'];

$query_args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => $settings['posts_per_page']
);

$nb_posts = new WP_Query($query_args);
?>

<div class="nb-post-wrapper <?php echo esc_attr($style_class);?>">
    <?php while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
        <div class="nb-post-item-wrapper">
            <?php if($style == 'style_1'):?>
                <div class="nb-post-item">
                    <?php
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
                    ?>
                    <div class="nb-post-date">
                        <?php echo date_i18n('j M Y', strtotime(get_the_date(''))); ?>
                    </div>
                    <div class="nb-post-thumbnail">
                        <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                        
                    </div>

                    <div class="nb-post-data">
                        <?php the_title( '<h4 class="nb-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );?>

                        <div class="nb-content">
                            <?php
                            $excerpt_length = 12;
                            if (has_excerpt()) :
                                echo '<p >' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_excerpt(), $excerpt_length, '...') : get_the_excerpt()) . '</p>';
                            else :
                                echo '<p>' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_content(), $excerpt_length, '...') : get_the_content()) . '</p>';
                            endif;
                            ?>
                        </div>
                        <div class="nb-extra-info">
                            <div class="nb-post-views">
                                <i class="icon-opened-eye-1"></i><span><?php echo retreatclub_getPostViews(get_the_ID()) . esc_html__(' Views', 'retreat-club-elements');?></span>
                            </div>
                            <div class="nb-post-reading-time">
                                <i class="icon-time"></i><?php echo get_reading_time(get_the_content());?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else:?>
                <div class="nb-post-item">
                    <?php
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
                    ?>
                    <div class="nb-post-thumbnail">
                        <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                        
                    </div>

                    <div class="nb-post-data">

                        <div class="nb-post-date">
                            <i class="icon-calendar"></i>
                            <?php echo date_i18n('F j, Y', strtotime(get_the_date(''))); ?>
                        </div>

                        <?php the_title( '<h4 class="nb-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );?>

                        <div class="nb-content">
                            <?php
                            if (has_excerpt()) :
                                echo '<p >' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_excerpt(), $excerpt_length, '...') : get_the_excerpt()) . '</p>';
                            else :
                                echo '<p>' . (absint($excerpt_length) > 0 ? wp_trim_words(get_the_content(), $excerpt_length, '...') : get_the_content()) . '</p>';
                            endif;
                            ?>
                        </div>
                        <div class="read-more-link">
                            <a href="<?php echo get_permalink(); ?>"><?php echo esc_html__('Read More', 'retreatclub-elements'); ?></a>
                            <i class="icon-double-right-arrow"></i>
                        </div>
                    </div>
                </div>
            <?php endif;?>
        </div>
    <?php endwhile;?>
    <?php wp_reset_postdata();?>
</div>