"use strict";
(function ($) {
    $.view_service_detail = function (element, options) {
        let defaults = {
            list_event: [],
            person: 1,
            service_item: [],
            title: '',
            render_list_review:"",
            items_per_page: 6,
            visiblePages: 3,
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let title = plugin.settings.title;
            if (title.trim() === '') {
                $('body').find('.entry-title').html('Service detail')
            } else {
                $('body').find('.entry-title').html(title)
            }

            let list_event = plugin.settings.list_event;
            let service_item = plugin.settings.service_item;
            let event_id;
            let event_choosen;
            let $gallery_large = $element.find('.block-gallery-slider-large');
            if($element.hasClass('style-1')){
                $gallery_large.slick({
                    infinite: true,
                    rows:1,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    prevArrow: ".arrow-prev",
                    nextArrow: ".arrow-next",
                    dots: false,
                    responsive: [{
                        breakpoint: 992,
                        settings: {
                            rows: 1,
                            arrows: false,
                            dots: true,
                            slidesToShow: 2,
                            slidesToScroll: 1
                        }
                    },
                        {
                            breakpoint: 577,
                            settings: {
                                rows: 1,
                                dots: true,
                                arrows: false,
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                        }]
                });
                $('.block-magnifig').magnificPopup({
                delegate: 'a',
                type: 'image',
                gallery:{enabled:true},
                });
                $(function() {
                    var $img_popup = $element.find('.block-magnifig a');
                    var isDragging = false;
                    $('.block-gallery-slider-large .slick-slide' )
                        .mousedown(function() {
                            console.log('aaaa');
                            $(window).mousemove(function() {
                                isDragging = true;
                                $(window).unbind("mousemove");
                            });
                        })
                        .mouseup(function() {
                            var wasDragging = isDragging;
                            isDragging = false;
                            $(window).unbind("mousemove");
                            if(!wasDragging){
                                let $index = $(this).index();
                                $($img_popup[$index]).trigger('click');
                            }
                        })
                });
            }
            let person = plugin.settings.person;
            if($element.hasClass('style-3')){
                var n;
                function thumbImg(){
                    n =  8;
                    let width_window = window.innerWidth;
                    if(width_window < 1200 && width_window > 768){
                        n = 6;
                    }else if(width_window <= 768 && width_window > 320){
                        n = 5;
                    }else if(width_window <= 320){
                        n = 4;
                    }
                }
                thumbImg();
                $(window).resize(function(){
                    thumbImg();
                })
                let srcs = plugin.settings.srcs;
                console.log(srcs);
                let $space_Between = 10;
                var galleryTop = new Swiper('.gallery-top', {
                    spaceBetween:0,
                    loop: false,
                    navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    },
                    observer: true,
                    observeParents: true,
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                        renderBullet: function (index, className) {
                            let classClick = " ";
                            if(index == (n-1)) {
                                classClick = " click-in";
                            }
                            return '<a href="'+ srcs[index]+'" class="' + className + classClick + '"><div style="background-image: url('+srcs[index]+');"></div></a>';
                        },
                    },
                });
                let $swiper_wrapper = $element.find('.gallery-top .swiper-wrapper');
                let $swiper_wrapper_img = $swiper_wrapper.find('.img-block')
                let $gallery_top = $element.find('.gallery-top .swiper-slide');
                let $thumbs = $element.find('.swiper-pagination');
                let $thumbs_img = $thumbs.find('.swiper-pagination-bullet');
                let $thumbs_number = $('.swiper-pagination .swiper-pagination-bullet').length;




                function fixSize() {
                    $($thumbs_img).css('margin-right','0px')
                    for (let i = 0; i < (n-1);i++){
                        $($thumbs_img[i]).css('margin-right',''+ $space_Between +'px')
                    }
                    let $rest_thumbs_number = $thumbs_number - n;
                    $($thumbs_img.find('p.rest')).remove();
                    if ($rest_thumbs_number > 0){
                        $($thumbs_img[n-1]).append("<p class='rest'>+"+ $rest_thumbs_number +"</p>");
                    }
                    $($thumbs_img).removeClass('click-in');
                    $($thumbs_img[n-1]).addClass('click-in');
                    let $width_wrapper = $swiper_wrapper.width();
                    let $width_thumb = $thumbs.width();
                    $swiper_wrapper_img.height((2*$width_wrapper)/3);
                    $swiper_wrapper_img.width($width_wrapper);
                    let $size = ($width_thumb-(n-1)*10)/n
                    let $bottom = $size + 75;
                    // Set width,height thumbs
                    $thumbs_img.width($size);
                    $thumbs_img.height($size);
                    $thumbs.height($size);

                    $thumbs.css('bottom',''+ -$size - 10+'px')

                    $('.slide-detail').css('padding-bottom',''+ $bottom +'px')
                }
                fixSize();

                $(window).resize(function(){
                    fixSize();
                });

                $('a.click-in').on('click',function(){
                    var $this = $(this);
                    $(".swiper-pagination a").not(this).addClass('click-in');
                    $('.swiper-pagination').magnificPopup({
                        delegate: 'a.click-in',
                        type: 'image',
                        gallery:{enabled:true},
                        callbacks: {
                            close: function(){
                                $(".swiper-pagination a").not($this).removeClass('click-in');
                            }
                        }
                    });
                })
            }
            $element.find('.social-service li a').on('click',function(){
                window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');
                return false;
            })
            $element.find('.counter-minus').click(function (e) {
                person = $element.find('input[type="text"].increment-number').val();
                $element.find('.number-person').text(person);
                if (typeof event_choosen !== 'undefined') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                } else {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                }

            });
            $element.find('.counter-plus').click(function (e) {
                person = $element.find('input[type="text"].increment-number').val();
                $element.find('.number-person').text(person);
                if (typeof event_choosen !== 'undefined') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                } else {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                }
            });
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            let $employee_input = $element.find('input[name=employee_id]');
            $employee_input.on('change', function () {
                let employee_id = $(this).val();
                let list_employee = service_item.list_employee;
                let employee_choosen = list_employee.find(function (employee) {
                    if (employee.id == employee_id) {
                        return employee;
                    }
                });
                $element.find('.trainer-info').text(`${employee_choosen.first_name} ${employee_choosen.last_name}`)
            });

            let list_working_day = service_item.working_day;
            let array_day_by_number = [];
            if (typeof list_working_day !== 'undefined' && list_working_day !== null && list_working_day.trim() !== '') {
                list_working_day = JSON.parse(list_working_day);
                let week = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                let array_diff = plugin.arr_diff(list_working_day, week);
                let day_of_week = {
                    'Sunday': 0,
                    'Monday': 1,
                    'Tuesday': 2,
                    'Wednesday': 3,
                    'Thursday': 4,
                    'Friday': 5,
                    'Saturday': 6
                };
                for (const prop in day_of_week) {
                    for (let i = 0; i < array_diff.length; i++) {
                        if (prop === array_diff[i]) {
                            array_day_by_number.push(day_of_week[prop]);
                        }
                    }
                }
            }

            $element.find('.form_datetime').datetimepicker('setDaysOfWeekDisabled', array_day_by_number);
            $element.find('.time-booking').on('change', function () {
                let value = $(this).val();
                let time_start = moment(value).format('LT');
                let time_end = moment(value).add(service_item.duration, 'hour').format('LT');
                let date_book = moment(value).format('YYYY-MM-DD');
                if (value !== '') {
                    $element.find('.local-time').text(`${time_start} - ${time_end}`);
                    $element.find('.date-info').text(date_book);
                } else {
                    $element.find('.local-time').text('');
                    $element.find('.date-info').text('');
                }
            });

            $element.find('.btn-book-now-detail').click(function (e) {
                let $form = $(this).closest('form[name="client-form"]');
                let employee_id = $form.find('input[name="employee_id"]').val();
                if (employee_id === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    }, 500, "linear");
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Expert</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                let time_value = $form.find('.mirror_field').val();
                if (time_value === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    }, 500, "linear");
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    $('body,html').animate({
                        scrollTop: $element.find('.wrapper-block-check-out').offset().top
                    }, 500, "linear");
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-booknow').click(function () {
                let $block_event = $(this).closest('.block-event-item');
                $('body,html').animate({
                    scrollTop: $element.find('form.booking-form').offset().top
                }, 500, "linear");
                event_id = $block_event.data('event_id');
                event_choosen = list_event.find(function (event) {
                    if (event.id == event_id) {
                        return event;
                    }
                });
                $element.find('input[name="event_id"]').val(event_id);
                $element.find('.location-info').text(event_choosen.list_location[0].address)
                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price));
                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price));
            });


            $element.find('form[name="form-review"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-save-review').on('click', function () {
                let $form = $(this).closest('form[name="form-review"]');
                let rating_ambience = $form.find('input[name="rating_ambience"]').val();
                let rating_cleanliness = $form.find('input[name="rating_cleanliness"]').val();
                let rating_staff = $form.find('input[name="rating_staff"]').val();
                let rating_value = $form.find('input[name="rating_value"]').val();
                if(rating_ambience === '' || rating_cleanliness === '' || rating_staff === '' || rating_value === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please rating star</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let $wrapper_list_review = $element.find('.wrapper-list-review');
            let $render_list_review = $(plugin.settings.render_list_review);
            let $render_item_review = $render_list_review.filter('.block-review-item');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $render_item_review.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4): 4;

            $element.find('.pagination-review').twbsPagination({
                totalPages: (total_page === 0)?1:total_page ,
                visiblePages: visiblePages,
                hideOnlyOnePage:true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function (event, page) {
                    var data_page = $render_item_review.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_list_review.empty();

                    $.each(data_page, function (index, review) {
                        $wrapper_list_review.append(review.outerHTML);
                    });

                }
            });
            $('body').on('click','.heart',function(e){
                let $service_item = $(this).closest('.category-name-heart');
                let service_id = $service_item.data('service_id');
                let user_id = $service_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id==""){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px; z-index:99999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        $wishlist_icon.find('i').show();
                        if($wishlist_icon.hasClass('loading-item')){
                            $wishlist_icon.toggleClass('active');
                        }
                        $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
            $element.find('.my-choice').click(function (e) {
                $('.my-choice').not(this).removeClass('active');
                $(this).addClass('active')
            });
        };

        plugin.formatNumber = function (num) {
            return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
        };
        plugin.arr_diff = function (a1, a2) {
            let a = [], diff = [];
            if (a1.length > 0 && a2.length > 0) {
                for (let i = 0; i < a1.length; i++) {
                    a[a1[i]] = true;
                }
                for (let i = 0; i < a2.length; i++) {
                    if (a[a2[i]]) {
                        delete a[a2[i]];
                    } else {
                        a[a2[i]] = true;
                    }
                }
                for (let k in a) {
                    diff.push(k);
                }
            }
            return diff;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_service_detail = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_service_detail')) {
                let plugin = new $.view_service_detail(this, options);
                $(this).data('view_service_detail', plugin);
            }
        });
    }
})(jQuery);
