jQuery(document).ready(function ($) {

    "use strict";
        
    $(".nb-testimonials-container").each(function(){
    
        var $this           = $(this),
            currentID       = $this.attr('id'),
            style           = $this.attr('data-style'),
            currentSelector = '#' + currentID + ' .nb-testimonials-wrapper';

        
        if(style == "multiple_column") {
            var testimonialParams = {
                grabCursor: true,
                slidesPerView: 1,
                spaceBetween: 30,
                observer: true,
                observeParents: true,
                speed:1000,
                pagination: {
                    el: '#' + currentID + ' .swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '#' + currentID + ' .swiper-button-next',
                    prevEl: '#' + currentID + ' .swiper-button-prev',
                },
                breakpoints: {
                    // when window width is >= 576px
                    576: {
                        slidesPerView: 2,
                        spaceBetween: 20
                    },
                    // when window width is >= 768px
                    768: {
                        slidesPerView: 2,
                    },
                    // when window width is >= 1200px
                    1025: {
                        slidesPerView: 3
                    }
                }
            }
            var testimonialSwiper = new Swiper(currentSelector, testimonialParams);
        }
        else if(style == "sync_thumbnail_content_1") {

            var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
            var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';

            var avatarParams = {
                slidesPerView: 3,
                slideToClickedSlide: true,
                spaceBetween: 32,
                watchSlidesVisibility: true,
                watchSlidesProgress: true,
                observer: true,
                observeParents: true,
            };

            var avatarSwiper = new Swiper(avatarSelector, avatarParams);

            var contentParams = {
                grabCursor: true,
                slidesPerView: 1,
                observer: true,
                observeParents: true,
                pagination: {
                    el: '#' + currentID + ' .swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '#' + currentID + ' .swiper-button-next',
                    prevEl: '#' + currentID + ' .swiper-button-prev',
                },
                thumbs: {
                    swiper: avatarSwiper
                }
            
            };
            
            
            var contentSwiper = new Swiper(contentSelector, contentParams);
        }
        else if(style == "sync_thumbnail_content_2") {

            var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
            var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';

            var avatarParams = {
                slidesPerView: 1,
                slideToClickedSlide: true,
                spaceBetween: 30,
                watchSlidesVisibility: true,
                watchSlidesProgress: true,
                observer: true,
                observeParents: true,
                breakpoints: {
                    // when window width is >= 768px
                    768: {
                        slidesPerView: 2
                    },
                    // when window width is >= 1200px
                    992: {
                        slidesPerView: 3
                    },
                    // when window width is >= 1200px
                    1200: {
                        slidesPerView: 4
                    }
                }
            };

            var avatarSwiper = new Swiper(avatarSelector, avatarParams);

            var contentParams = {
                grabCursor: true,
                slidesPerView: 1,
                observer: true,
                observeParents: true,
                pagination: {
                    el: '#' + currentID + ' .swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '#' + currentID + ' .swiper-button-next',
                    prevEl: '#' + currentID + ' .swiper-button-prev',
                },
                thumbs: {
                    swiper: avatarSwiper
                }
            
            };
            
            
            var contentSwiper = new Swiper(contentSelector, contentParams);
        }
                
    });

});