"use strict";
(function ($) {
    $.block_location = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.slider').slick({
                dots: true,
                infinite: true,
                slidesToShow: 5,
                slidesToScroll: 1,
                arrows: false,
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            arrows: false,
                            slidesToShow: 4,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            arrows: false,
                            slidesToShow: 3,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll:1
                        }
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 375,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_location = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_location')) {
                let plugin = new $.block_location(this, options);
                $(this).data('block_location', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);
