"use strict";
(function ($) {
    $.block_location = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.slider').slick({
                dots: true,
                infinite: true,
                slidesToShow: 5,
                slidesToScroll: 1,
                arrows: false,
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            arrows: false,
                            slidesToShow: 4,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            arrows: false,
                            slidesToShow: 3,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll:1
                        }
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 375,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_location = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_location')) {
                let plugin = new $.block_location(this, options);
                $(this).data('block_location', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);

(function ($) {
    $.block_categoryimage = function (element, options) {
        var defaults = {
            class_name_drawerel:""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.sp-slide').slick({
                infinite: true,
                rows:1,
                slidesToShow: 6,
                slidesToScroll: 1,
                arrows: false,
                dots: false,
                responsive: [{
                    breakpoint: 993,
                    settings: {
                        rows: 1,
                        arrows: false,
                        dots: true,
                        slidesToShow: 4,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        rows: 1,
                        arrows: false,
                        dots: true,
                        slidesToShow:3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 576,
                    settings: {
                        rows: 1,
                        arrows: false,
                        dots: true,
                        slidesToShow:2,
                        slidesToScroll: 2
                    }
                },
                {
                    breakpoint: 481,
                    settings: {
                        rows: 1,
                        arrows: false,
                        dots: true,
                        slidesToShow:1,
                        slidesToScroll: 1
                    }
                }]
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.block_categoryimage = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('block_categoryimage')) {
                var plugin = new $.block_categoryimage(this, options);
                $(this).data('block_categoryimage', plugin);
            }
        });
    }
})(jQuery);

jQuery(document).ready(function() {
    jQuery(window).scroll(function () {
        if (jQuery(window).scrollTop() >0){
            jQuery('.header-1.fixed').addClass('effect-header').animate('5000');
        }
        else{
            jQuery('.header-1.fixed').removeClass('effect-header').animate('5000');
        }
        if (jQuery(window).scrollTop() >0){
            jQuery('.header-2.fixed').addClass('effect-header');
        }
        else{
            jQuery('.header-2.fixed').removeClass('effect-header');
        }
        if (jQuery(window).scrollTop() >130){
            jQuery('.header-3.fixed').addClass('effect-header');
        }
        else{
            jQuery('.header-3.fixed').removeClass('effect-header');
        }
        if (window.innerWidth <767) {
            if (jQuery(window).scrollTop() >0){
                jQuery('.header-3.fixed').addClass('effect-header');
            }
            else{
                jQuery('.header-3.fixed').removeClass('effect-header');
            }
        }
    });
    setTimeout(function(){
        var topSubPages = jQuery('.fixed').innerHeight();
        var  topSubPagesShot = topSubPages - 40;
        if(jQuery('header').hasClass('fixed')){
            jQuery('.nb-page-title-wrap').css('padding-top', topSubPages + 'px');
            jQuery('.banner-home').css('margin-top', topSubPagesShot + 'px');
            jQuery('.banner-home').addClass('banner-span');
            jQuery('.banner-home3').css('margin-top', topSubPagesShot + 'px');
            jQuery('.banner-home3').addClass('banner-home3-span');
        }
        else {
            jQuery('.nb-page-title-wrap').css('padding-top', 0 + 'px');
            jQuery('.banner-home').css('margin-top', 0 + 'px');
            jQuery('.banner-home').removeClass('banner-span');
            jQuery('.banner-home3').css('margin-top', 0 + 'px');
            jQuery('.banner-home3').removeClass('banner-home3-span');
        }
    }, 500);
    //config icon detail
    jQuery('.item-our-service .icon div').html('');
});




//config  detail scrfoll
jQuery(document).ready(function(){
    if (window.innerWidth >991) {
        if( jQuery( '.listing-nav-container' ).length > 0 ){
            var scrollDetail = jQuery('.listing-nav-container').offset().top;
            var itemScrollDetail = scrollDetail - 50;
            jQuery(window).scroll(function () {
                if (jQuery(window).scrollTop() > itemScrollDetail){
                    jQuery('body').addClass('effect-detail');
                }
                else{
                    jQuery('body').removeClass('effect-detail');
                }
            });

            jQuery(function () {
                var height_sticky_menu = jQuery('#listing-nav').length > 0 ? jQuery('#listing-nav').height() : 0;
                var itemStickyDetail = height_sticky_menu - 35;

                jQuery('.listing-nav li a.overview').on('click',function (event) {
                     event.preventDefault();
                    jQuery(window).scrollTop(jQuery('#overview').offset().top - itemStickyDetail);
                });
                jQuery('.listing-nav li a.video').on('click',function (event) {
                    event.preventDefault();
                    jQuery(window).scrollTop(jQuery('#video').offset().top - itemStickyDetail);
                });

                jQuery('.listing-nav li a.booking').on('click',function (event) {
                    event.preventDefault();
                    jQuery(window).scrollTop(jQuery('#booking').offset().top - itemStickyDetail);
                });
                jQuery('.listing-nav li a.reviews').on('click',function () {
                    event.preventDefault();
                    jQuery(window).scrollTop(jQuery('#reviews').offset().top - itemStickyDetail);
                });
                jQuery('.listing-nav li a.add-review').on('click',function () {
                    event.preventDefault();
                    jQuery(window).scrollTop(jQuery('#add-review').offset().top - itemStickyDetail);
                });
            });
        }
    }
});



(function ($) {
    $.block_destination = function (element, options) {
        var defaults = {
            class_name_drawerel:""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.slider-destination').slick({
                infinite: true,
                rows:1,
                slidesToShow: 4,
                slidesToScroll: 1,
                prevArrow: ".arrow-prev",
                nextArrow: ".arrow-next",
                dots: false,
                responsive: [{
                    breakpoint: 992,
                    settings: {
                        rows: 1,
                        arrows: false,
                        dots: true,
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                    {
                        breakpoint: 577,
                        settings: {
                            rows: 1,
                            dots: true,
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }]
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.block_destination = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('block_destination')) {
                var plugin = new $.block_destination(this, options);
                $(this).data('block_destination', plugin);
            }
        });
    }
})(jQuery);


(function ($) {
    $.block_meetourcoachs_default = function (element, options) {
        var defaults = {
            class_name_drawerel: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.employee-slider').slick({
                slidesToShow: 4,
                slidesToScroll: 4,
                infinite: true,
                arrows: false,
                dots: false,
                responsive: [
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true,
                        }
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true,
                        }
                    },
                    {
                        breakpoint: 425,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true,
                        }
                    }
                ]
            });
            $element.find('.image-employee').hover(function (e) {
                $(this).addClass('hover');
            }, function () {
                $(this).removeClass('hover');
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.block_meetourcoachs_default = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('block_meetourcoachs_default')) {
                var plugin = new $.block_meetourcoachs_default(this, options);
                $(this).data('block_meetourcoachs_default', plugin);
            }
        });
    }
})(jQuery);

(function ($) {
    $.block_list_service_default = function (element, options) {
        var defaults = {
            
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.slider').slick({
                dots:false,
                infinite: false,
                slidesToShow: 3,
                slidesToScroll:1,
                arrows: true,
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            dots:false,
                            arrows: true,
                            slidesToShow: 3,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            dots:true,
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 769,
                        settings: {
                            dots:true,
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 650,
                        settings: {
                            dots:true,
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
            $element.find('.heart').on('click',function(e){
                let $service_item = $(this).closest('.wishlist-item');
                let service_id = $service_item.data('service_id');
                let user_id = $service_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id=="" || user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:99999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        $wishlist_icon.find('i').show();
                        if($wishlist_icon.hasClass('loading-item')){
                            $wishlist_icon.toggleClass('active');
                        }
                        $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
                
            })
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.block_list_service_default = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('block_list_service_default')) {
                var plugin = new $.block_list_service_default(this, options);
                $(this).data('block_list_service_default', plugin);
            }
        });
    }
})(jQuery);

jQuery(document).ready(function() {
    jQuery(".has-account a,.lost").click(function() {
        jQuery(".tab_content_login").hide();
        var activeTab = jQuery(this).attr("href");
        jQuery(activeTab).show();
    });
});
jQuery(document).ready(function($)
{
    // Show the login dialog box on click
    $('a#show_login,a.show_login,.icon-user-mobile, .login-pc a').on('click', function(e){
        $('.retreatclub-singup-register').after('<div class="login_overlay"></div>');
        $('.retreatclub-singup-register').fadeIn(500);
        $('div.login_overlay, #login-register-password a.close').on('click', function(event){
            event.preventDefault();
            $('div.login_overlay').remove();
            $('.retreatclub-singup-register').hide();
        });
        e.preventDefault();
    });
});

jQuery(document).ready(function($) {
    let $login = $('.retreatclub-singup-register').find('.tab_container_login');
    let $url_add = retreat_elements.siteUrl+'/sellercenter/wb_service/?layout=form';
    if ($login.length > 0) {
        $('.btn-book-now').on('click', function(e){
            $('.retreatclub-singup-register').after('<div class="login_overlay"></div>');
            $('.retreatclub-singup-register').fadeIn(500);
            $('div.login_overlay, #login-register-password a.close').on('click', function(event){
                event.preventDefault();
                $('div.login_overlay').remove();
                $('.retreatclub-singup-register').hide();
            });
            e.preventDefault();
        });
    }
    else{
        $('.btn-header a').attr('href',$url_add);
    }
});
jQuery(document).ready(function ($) {

    "use strict";
        
    $(".nb-testimonials-container").each(function(){
    
        var $this           = $(this),
            currentID       = $this.attr('id'),
            style           = $this.attr('data-style'),
            currentSelector = '#' + currentID + ' .nb-testimonials-wrapper';

        
        if(style == "multiple_column") {
            var testimonialParams = {
                grabCursor: true,
                slidesPerView: 1,
                spaceBetween: 30,
                observer: true,
                observeParents: true,
                speed:1000,
                pagination: {
                    el: '#' + currentID + ' .swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '#' + currentID + ' .swiper-button-next',
                    prevEl: '#' + currentID + ' .swiper-button-prev',
                },
                breakpoints: {
                    // when window width is >= 576px
                    576: {
                        slidesPerView: 2,
                        spaceBetween: 20
                    },
                    // when window width is >= 768px
                    768: {
                        slidesPerView: 2,
                    },
                    // when window width is >= 1200px
                    1025: {
                        slidesPerView: 3
                    }
                }
            }
            var testimonialSwiper = new Swiper(currentSelector, testimonialParams);
        }
        else if(style == "sync_thumbnail_content_1") {

            var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
            var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';

            var avatarParams = {
                slidesPerView: 3,
                slideToClickedSlide: true,
                spaceBetween: 32,
                watchSlidesVisibility: true,
                watchSlidesProgress: true,
                observer: true,
                observeParents: true,
            };

            var avatarSwiper = new Swiper(avatarSelector, avatarParams);

            var contentParams = {
                grabCursor: true,
                slidesPerView: 1,
                observer: true,
                observeParents: true,
                pagination: {
                    el: '#' + currentID + ' .swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '#' + currentID + ' .swiper-button-next',
                    prevEl: '#' + currentID + ' .swiper-button-prev',
                },
                thumbs: {
                    swiper: avatarSwiper
                }
            
            };
            
            
            var contentSwiper = new Swiper(contentSelector, contentParams);
        }
        else if(style == "sync_thumbnail_content_2") {

            var avatarSelector = '#' + currentID + ' .nb-testimonials-avatar-wrapper';
            var contentSelector = '#' + currentID + ' .nb-testimonials-content-wrapper';

            var avatarParams = {
                slidesPerView: 1,
                slideToClickedSlide: true,
                spaceBetween: 30,
                watchSlidesVisibility: true,
                watchSlidesProgress: true,
                observer: true,
                observeParents: true,
                breakpoints: {
                    // when window width is >= 768px
                    768: {
                        slidesPerView: 2
                    },
                    // when window width is >= 1200px
                    992: {
                        slidesPerView: 3
                    },
                    // when window width is >= 1200px
                    1200: {
                        slidesPerView: 4
                    }
                }
            };

            var avatarSwiper = new Swiper(avatarSelector, avatarParams);

            var contentParams = {
                grabCursor: true,
                slidesPerView: 1,
                observer: true,
                observeParents: true,
                pagination: {
                    el: '#' + currentID + ' .swiper-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '#' + currentID + ' .swiper-button-next',
                    prevEl: '#' + currentID + ' .swiper-button-prev',
                },
                thumbs: {
                    swiper: avatarSwiper
                }
            
            };
            
            
            var contentSwiper = new Swiper(contentSelector, contentParams);
        }
                
    });

});
"use strict";
(function ($) {
    $.view_list_servicelocator = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            page_list_service:'',
            list_service:[],
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_service = plugin.settings.list_service;
            $element.find('select.list-location').select2();
            $element.find('select.list-employee').select2();
            $element.find('.ul-list-service').slideUp();
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [0, 1099],
                create: function () {
                    $("#amount_1").val("$0 - $1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").val("$" + ui.values[0] + " - $" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value)).trigger('change');
                }
            });

              $('.title-load-more').next('.block-filter-load-more').slideUp();
            $('body').on('click','.title-load-more', function() {
                $(this).addClass('active');
                $(this).find("span").toggleClass("icon-minus icon-plush",300);
                $(this).next('.block-filter-load-more').slideToggle("slow");
            })
            
            $element.closest('.wpbooking-pro-view').addClass('wpbooking-pro-view-locator');
            $element.find('.nav-tabs > div').on('click', function () {
                $(this).addClass('active');
                $element.find('.nav-tabs > div').not(this).removeClass('active');
            });

            $element.find('.sort-display a').on('click',function (e) {
                let $form = $(this).closest('form[name="filter-form"]')
                let key_sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                $element.find('input[name="sort"]').val(key_sort).trigger('change');
                $element.find('input[name="direction"]').val(direction).trigger('change');
                $element.find('.sort-by-price .dropdown').removeClass('open');
                $form.submit();
            });
            let $select_sort_item = $element.find('.sort-display a.select-sort-item');

            $element.find('.sort-by-price .dropdown').on('click', function () {
                $(this).find('i').addClass('active');
                if($(this).hasClass('open') === false) {
                    $(this).find('i').removeClass('active');
                }
            });

            $element.find('input[name="direction"]').on('change', function () {
                let val = $(this).val();
                $.each($select_sort_item, function (index, item) {
                    let direction = $(item).data('direction');
                    if(val === direction) {
                        $(item).addClass('active');
                        let text = $(item).text();
                        $element.find('span.select-by-default').text(text);
                    } else {
                        $(item).removeClass('active');
                    }
                })
            });

            $element.find('input.input-near-me').on('change', function () {
                if($(this).is(":checked")) {
                    if(navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(function(position) {
                            var latitude = position.coords.latitude;
                            var longitude = position.coords.longitude;
                            $element.find('input[name="latitude"]').val(latitude).trigger('change');
                            $element.find('input[name="longitude"]').val(longitude).trigger('change');
                        }, function () {
                            $element.find('input[name="latitude"]').val('').trigger('change');
                            $element.find('input[name="longitude"]').val('').trigger('change');
                        })
                    } else {
                        alert("Sorry, your browser does not support HTML5 geolocation.");
                    }
                } else {
                    $element.find('input[name="latitude"]').val('').trigger('change');
                    $element.find('input[name="longitude"]').val('').trigger('change');
                }
            })

            var filterAjax = plugin.debounce(function () {
                let $form = $(this).closest('form[name="filter-form"]');
                $form.submit();
            }, 1000);
            $element.find('input[name="keyword"]').on('keyup',filterAjax);

            $element.find('select[name="employee"]').on('change', filterAjax);
            $element.find('select[name="location_id"]').on('change', filterAjax);

            $element.find('input[name="category_id[]"]').on('change', filterAjax);
            $element.find('input[name="total_rating_avg[]"]').on('change', filterAjax);
            $element.find('input[name="latitude"]').on('change', filterAjax);
            $element.find('input[name="longitude"]').on('change', filterAjax);
            $element.find('input[name="price_search"]').on('change', filterAjax);
            $('body').on('click','.nav-tabs li', function(event) {
                event.preventDefault();
                let layout = $(this).data('layout');
                $element.find('input[name="tab"]').val(layout);
            });
            $('body').on('click','.nav-tabs li', filterAjax);
            $element.find('#bh-sl-map-container').storeLocator({
                ajaxData:function (e) {
                    var output = plugin.convert_data_form();
                    let dataObj = {};
                    $(output).each(function(i, field){
                        dataObj[field.name] = field.value;
                    });
                    return dataObj;
                },
                'querystringParams' : true,
                'fullMapStart': true,
                'pagination': true,
                'storeLimit': plugin.settings.store_limit,
                // The following paths are set because this example is in a subdirectory
                'dataLocation': `${wpbookingpro_root_url}${wpbookingpro_api_task}/?task=services.ajax_get_list_service`,
                'infowindowTemplatePath': `${wpbookingpro_root_url}/wp-content/plugins/wpbookingpro/frontend/resources/store_locator/assets/js/plugins/storeLocator/templates/infowindow-description.html`,
                'listTemplatePath': `${wpbookingpro_root_url}/wp-content/plugins/wpbookingpro/frontend/resources/store_locator/assets/js/plugins/storeLocator/templates/location-list-description.html`,
                'gridTemplatePath': `${wpbookingpro_root_url}/wp-content/plugins/wpbookingpro/frontend/resources/store_locator/assets/js/plugins/storeLocator/templates/location-grid-description.html`,
            });
            $('body').on('click','.heart',function(e){
                let $service_item = $(this).closest('.wishlist-item');
                let service_id = $service_item.data('service_id');
                let user_id = $('.view-list-servicelocator').data('user_id');
                let $wishlist_icon = $(this);
                if(user_id=="" || user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:99999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {

                    },
                    complete: function () {
                        $wishlist_icon.find('i').show();
                        if($wishlist_icon.hasClass('loading-item')){
                            $wishlist_icon.toggleClass('active');
                        }
                        $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
        };

        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-service').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };

        plugin.filter_ajax = function(dataObj) {
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_filter",
                    page_detail_service: plugin.settings.page_detail_service
                },
                beforeSend: function() {
                    $('body').loadingModal();
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    $element.find('.data-listservice-ajax .block-top-result .number').text(data.data.total +" services found");
                },
                error: function(xhr) { // if error occured

                },
                complete: function() {
                    $('body').loadingModal('destroy');

                },
            })
        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        var scrollMap = plugin.debounce(function () {
                var $sticky = $element.find('#bh-sl-map');
                if ($sticky.length > 0) {
                    $($sticky).stick_in_parent()
                        .on('sticky_kit:bottom', function(e) {
                            $($sticky).removeClass('custom-sticky');
                        })
                        .on('sticky_kit:unbottom', function(e) {
                            $($sticky).addClass('custom-sticky');
                        });

                    $(window).on('resize', function () {
                        $($sticky).trigger('sticky_kit:detach');
                    });
                }
        }, 250);
        $(window).scroll(scrollMap);
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_servicelocator = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_servicelocator')) {
                let plugin = new $.view_list_servicelocator(this, options);
                $(this).data('view_list_servicelocator', plugin);
            }
        });
    }
})(jQuery);

"use strict";
(function ($) {
    $.view_list_services = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            page_detail_service:'',
        };

        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        var $height = $('.nojq').height();
        var $height1 = 0;
        var a;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $checkbox_category = $element.find('.check-box-category');
            let $checkbox_service = $element.find('.check-box-service');
            let dropdown_toggle = $element.find('.dropdown-toggle');
            let $direction = $element.find('input[name="direction"]').val();            
            $checkbox_category.on('ifChecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                $ul_list_service.find('.check-box-service').iCheck('check');

            });

            if($direction ==="ASC"){
                dropdown_toggle.find('.sort-by').text('Lowest Price');
            }else if($direction === "DESC"){
                dropdown_toggle.find('.sort-by').text('Highest Price');
            } else {
                dropdown_toggle.find('.sort-by').text('Sort By');
            }
            $checkbox_category.on('ifUnchecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                if (!triggeredByChild) {
                    $ul_list_service.find('.check-box-service').iCheck('uncheck');
                }
            });
            $checkbox_service.on('ifUnchecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                $block_label.find('.check-box-category').iCheck('uncheck');
            });
            $checkbox_service.on('ifChecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                let $current_service=$ul_list_service.find('.check-box-service');
                if ($current_service.filter(':checked').length === $current_service.length) {
                    $block_label.find('.check-box-category').iCheck('check');
                }
            });

            $element.find('.ul-list-service').slideUp();
            $element.find('.icon-nb-down-arrow').click(function (e) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service =$block_label.next();
                $ul_list_service.slideToggle();
                $(this).toggleClass('active')
            });

            $(window).scroll(function() {
                plugin.fixTopSidebar();
            });

            $element.find('select.list-location').select2();
            $element.find('select.list-employee').select2();
            $element.find('input.input-near-me').on('change', function () {
                if($(this).is(":checked")) {
                    if(navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(function(position) {
                            var latitude = position.coords.latitude;
                            var longitude = position.coords.longitude;
                            $element.find('input[name="latitude"]').val(latitude);
                            $element.find('input[name="longitude"]').val(longitude);
                        }, function () {
                            $element.find('input[name="latitude"]').val('');
                            $element.find('input[name="longitude"]').val('');
                        })
                    } else {
                        alert("Sorry, your browser does not support HTML5 geolocation.");
                    }
                } else {
                    $element.find('input[name="latitude"]').val('');
                    $element.find('input[name="longitude"]').val('');
                }
            });
            /*
             * Start: Viet Dev
             */
            let limit=parseInt(plugin.settings.limit);
            $element.find('input[name="limit1"]').val(limit);
            let page = parseInt(plugin.settings.page);
            let start = parseInt(plugin.settings.start); 
            $(window).load(function() {
                $element.find('input[name="start"]').val(0);
                $element.find('input[name="limit1"]').val(limit);                
            });  
            var filterAjaxEvent = plugin.debounce(function () {  
                $element.find('input[name="limit1"]').val(limit);
                $element.find('input[name="start"]').val(0);
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_ajax(dataObj);
            }, 300);
            $element.find('input[name="limit"]').val(limit);
            $element.find('input[name="keyword"]').on('keyup', filterAjaxEvent);
            $element.find('select[name="employee_id"]').on('change', filterAjaxEvent);
            $element.find('select[name="location_id"]').on('change', filterAjaxEvent);
            $element.find('.ul-list-category input[name="category_id[]"]').on('change', filterAjaxEvent);
            $element.find('.ul-list-rating input[name="total_rating_avg[]"]').on('change', filterAjaxEvent);
            $('body').on('click','.nav-tabs li', function() {
                let layout = $(this).data('layout');
                $element.find('input[name="tab"]').val(layout);
            })     
            let input_page = page;            
            var filterAjaxEventLoadMore = plugin.debounce(function () { 
                $element.find('input[name="limit1"]').val(limit);
                $element.find('input[name="start"]').val(0);
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_ajax(dataObj);
            }, 300);
            var filterAjaxLoadMore = plugin.debounce(function () {  
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.filter_loadmore_ajax(dataObj);
            }, 300);
            var tabAjaxEvent = plugin.debounce(function () {  
                $element.find('#pagination-services-ajax').hide()            
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                plugin.tab_ajax(dataObj);
            }, 300);
            $element.find('#pagination-services-ajax').on('click', function() {
                let input_limit = parseInt($element.find('input[name="limit1"]').val());
                let input_page = page;
                let input_start = parseInt($element.find('input[name="start"]').val());
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                input_start = parseInt(input_start)+limit;
                $element.find('input[name="start"]').val(input_start);
                input_limit = parseInt(input_limit)+limit;
                $element.find('input[name="limit1"]').val(input_limit);
                input_page = parseInt(input_page)+page;
                $element.find('input[name="page"]').val(input_page);
                $element.find('input[name="link_load"]').val('1');
            });
            $element.find('#pagination-services-ajax').on('click', filterAjaxLoadMore);
            $('body').on('click', '.nav-tabs li', tabAjaxEvent);     
            $element.find('.sort-display a').click(filterAjaxEventLoadMore);    
            $element.find('.sort-display a').click(function(){
                let dropdown_toggle = $element.find('.dropdown-toggle');
                let $direction = $element.find('input[name="direction"]').val();
                let $form=$element.find('form.form-search-service');
                let sort=$(this).data('sort');
                let direction=$(this).data('direction');
                $element.find('input[name="sort"]').val(sort);
                $element.find('input[name="direction"]').val(direction);
                $element.find('.sort-by-price .dropdown').removeClass('open');
            });    
            // $(window).load(function() {
            //     var sPageURL = window.location.search.substring(1),
            //     sURLVariables = sPageURL.split('&'),
            //     sParameterName,
            //     i;
            //     for (i = 0; i < sURLVariables.length; i++) {
            //         sParameterName = sURLVariables[i].split('=');

            //         if (sParameterName[0] === sParam) {
            //             return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
            //         }
            //     }
            // });

            /*
             * End: Viet Dev
             */
            $('body').on('click','.category-name-heart .heart',function(e){
                let $service_item = $(this).closest('.wishlist-item');
                let service_id = $service_item.data('service_id');
                let user_id = $element.find('.data-listservice-ajax').data('user-id');
                let $wishlist_icon = $(this);

                if(user_id=="" && user_id==0){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px;z-index:99999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        $wishlist_icon.find('i').show();
                        if($wishlist_icon.hasClass('loading-item')){
                            $wishlist_icon.toggleClass('active');
                        }
                        $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
            let total_record=plugin.settings.total_record;
            let $fist_show=true;
            if (total_record>limit && total_record % limit >0 ){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt((total_record/limit) + 1),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            let rating = $element.find('.list-rating');
                            let total_rating_avg= rating.find('input[name="total_rating_avg"]');
                            total_rating_avg.removeAttr('checked');
                            let label_category = $element.find('.label-category');
                            let check_box=label_category.find('input[name="category_id[]"]');
                            check_box.prop('checked', false);
                            let ul_list_service =$element.find('.ul-list-service');
                            ul_list_service.find('input').prop('checked', false);
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            // console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else if(total_record>limit && total_record % limit ==0){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt(total_record/limit),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            let rating = $element.find('.list-rating');
                            let total_rating_avg= rating.find('input[name="total_rating_avg"]');
                            total_rating_avg.removeAttr('checked');
                            let label_category = $element.find('.label-category');
                            let check_box=label_category.find('input[name="category_id[]"]');
                            check_box.prop('checked', false);
                            let ul_list_service =$element.find('.ul-list-service');
                            ul_list_service.find('input').prop('checked', false);
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            // console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            }
            else if(total_record<=limit && total_record>0) {
                $element.find('#pagination-services').twbsPagination({
                    totalPages: 1,
                    visiblePages: 1,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.form-search-service');
                            let rating = $element.find('.list-rating');
                            let total_rating_avg= rating.find('input[name="total_rating_avg"]');
                            total_rating_avg.removeAttr('checked');
                            let label_category = $element.find('.label-category');
                            let check_box=label_category.find('input[name="category_id[]"]');
                            check_box.prop('checked', false);
                            let ul_list_service =$element.find('.ul-list-service');
                            ul_list_service.find('input').prop('checked', false);
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            // console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else {
                $element.find('#pagination-services').hide();
            }
            plugin.sticky_sidebar()
            $(window).on('resize', function () {
                plugin.sticky_sidebar()
            });
            var b ;
            $(window).scroll(function() {
              b = window.pageYOffset;
              // console.log(b)
            });
        };
        plugin.fixTopSidebar =  function(){
            $height1 = $('.site-header.effect-header').height();
            a = $height1 + $height + 30;
            $element.find('.wrapper-search-service.is_stuck.custom-sticky').css({
                'top' : a+'px' ,
                'transition':'top 0.3s'
            })
        }
        plugin.sticky_sidebar=function(){
            var $sticky = $element.find('.wrapper-search-service');
            if ($sticky.length > 0) {
                $($sticky).stick_in_parent()
                    .on('sticky_kit:bottom', function(e) {
                        $($sticky).removeClass('custom-sticky');
                    })
                    .on('sticky_kit:unbottom', function(e) {
                        $($sticky).addClass('custom-sticky');
                    });

                $(window).on('resize', function () {
                    $($sticky).trigger('sticky_kit:detach');
                });
            }
        }
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('.form-search-service').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.filter_ajax = function(dataObj) {
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_by_keyword",
                    page_service_detail: plugin.settings.page_service_detail,
                    page_list_service: plugin.settings.page_list_service
                },
                beforeSend: function() {
                    $('body').loadingModal(); 
                    $(window).load(function() {
                        $element.find('#pagination-services-ajax').hide();
                    });
                },
                success: function(res) {
                    
                    let data= JSON.parse(res);
                    $element.find('.wrapper-service-list').empty();
                    $element.find('.wrapper-service-grid').empty();
                    
                    if( data.data.template1 || data.data.template2 ) {
                        $element.find('.wrapper-service-list').append(data.data.template2); 
                        $element.find('.wrapper-service-grid').append(data.data.template1);
                    }else {
                        $element.find('.wrapper-service-list').append('<div class="alert-block"><span>Could not found any services</span></div>'); 
                        $element.find('.wrapper-service-grid').append('<div class="alert-block"><span>Could not found any services</span></div>');
                    }
                    if(data.data.total) {
                        $element.find('#pagination-services-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-services-ajax').show();
                        }
                         $element.find('.data-listservice-ajax .block-top-result .number').text(data.data.total +" services found");
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }
                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).data('layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }
                        });
                        var $direction = $element.find('input[name="direction"]').val();
                        if($direction ==="ASC"){
                            $element.find('.sort-by').text('Lowest Price');
                        }else if($direction === "DESC"){
                            $element.find('.sort-by').text('Highest Price');
                        } else {
                            $element.find('.sort-by').text('Sort By');
                        };
                        $(window).load(function() {
                        $element.find('#pagination-services-ajax').show();
                        });
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if( index == "keyword" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "category_id[]") {
                                $params += "&category_id="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }                     
                },
            })
        };
        plugin.tab_ajax = function(dataObj) {
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_by_keyword",
                    page_service_detail: plugin.settings.page_service_detail,
                    page_list_service: plugin.settings.page_list_service
                },
                beforeSend: function() {
                    $('body').loadingModal(); 
                    $(window).load(function() {
                        $element.find('#pagination-services-ajax').hide();
                    });
                },
                success: function(res) {
                    
                    let data= JSON.parse(res);
                    if(data.data.total) {
                        $element.find('#pagination-services-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-services-ajax').show();
                        }
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }
                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).data('layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }
                        });
                        var $direction = $element.find('input[name="direction"]').val();
                        if($direction ==="ASC"){
                            $element.find('.sort-by').text('Lowest Price');
                        }else if($direction === "DESC"){
                            $element.find('.sort-by').text('Highest Price');
                        } else {
                            $element.find('.sort-by').text('Sort By');
                        };
                        $(window).load(function() {
                            $element.find('#pagination-services-ajax').show();
                        });
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {
                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if( index == "keyword" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "category_id[]") {
                                $params += "&category_id="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    }                     
                },
            })
        };
        var y ;
        plugin.filter_loadmore_ajax = function(dataObj) {
            $.ajax({
                url: wpbookingpro_root_url+wpbookingpro_api_task,
                type: 'POST',
                dataType: 'json',
                data: {
                    dataObj: JSON.stringify(dataObj),
                    task: "services.get_list_services_by_keyword",
                    page_service_detail: plugin.settings.page_service_detail,
                    page_list_service: plugin.settings.page_list_service
                },
                beforeSend: function() {
                    $('body').loadingModal(); 
                    
                    y = parseInt(window.pageYOffset);
                    // console.log('beforeSend',y);
                },
                success: function(res) {
                    let data= JSON.parse(res);
                    if (!$('.wrapper-search-service.is_stuck').hasClass('custom-sticky')){
                        $('.wrapper-search-service.is_stuck').addClass('custom-sticky');
                    }
                    plugin.fixTopSidebar();
                    if( data.data.template1 || data.data.template2 ) {
                        $element.find('.wrapper-service-list').append(data.data.template2); 
                        $element.find('.wrapper-service-grid').append(data.data.template1);
                    }
                    if(data.data.total) {
                        $element.find('#pagination-services-ajax').attr("data-total",data.data.total);
                        $element.find('input[name="total_item"]').val(data.data.total);
                        let limit1 = $element.find('input[name="limit1"]').val();
                        if( data.data.total > limit1 ) {
                            $element.find('#pagination-services-ajax').show();
                        }
                    }
                    if(data.data.layout) {
                        $element.find('.nav-tabs li').each(function(index, el) {
                            $(el).removeClass('active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('active');
                            }
                        });
                        $element.find('.tab-contents > div').each(function(index, el) {
                            $(el).removeClass('in active');
                            if($(el).attr('data-layout') == data.data.layout) {
                                $(el).addClass('in active');
                            }

                        });
                        var $direction = $element.find('input[name="direction"]').val();
                        if($direction ==="ASC"){
                            $element.find('.sort-by').text('Lowest Price');
                        }else if($direction === "DESC"){
                            $element.find('.sort-by').text('Highest Price');
                        } else {
                            $element.find('.sort-by').text('Sort By');
                        };
                    }
                },
                error: function(xhr) { // if error occured
                    
                },
                complete: function() {
                    $('body').loadingModal('destroy');
                    if (history.pushState) {

                        var $params = "";
                        $.each(dataObj, function(index, val) {
                            if( index == "keyword" ) {
                                $params += "?"+index+"="+val;
                            }
                            else if ( index == "layout") {
                                $params += "&"+index+"="+val;
                            }else if ( index == "rating[]") {
                                $params += "&rating="+val;
                            }
                            else {
                                $params += "&"+index+"="+val;
                            }
                        });
                        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + $params;
                        window.history.pushState({path:newurl},'',newurl);
                    } 
                    // console.log('complete',y)
                    window.scrollTo(0,y);  

                },
            })
        };
        plugin.example_function = function () {
        }
        plugin.window_after_load = function() {
            var output = plugin.convert_data_form();
            let dataObj = {};
            $(output).each(function(i, field){
                dataObj[field.name] = field.value;
            });
            plugin.filter_ajax(dataObj);
        }
        plugin.init();
        // plugin.window_after_load();
    }
    $.fn.view_list_services = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_services')) {
                let plugin = new $.view_list_services(this, options);
                $(this).data('view_list_services', plugin);
            }
        });
    }
})(jQuery);
"use strict";
(function ($) {
    $.view_service_detail = function (element, options) {
        let defaults = {
            list_event: [],
            person: 1,
            service_item: [],
            title: '',
            render_list_review:"",
            items_per_page: 6,
            visiblePages: 3,
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let title = plugin.settings.title;
            if (title.trim() === '') {
                $('body').find('.entry-title').html('Service detail')
            } else {
                $('body').find('.entry-title').html(title)
            }

            let list_event = plugin.settings.list_event;
            let service_item = plugin.settings.service_item;
            let event_id;
            let event_choosen;
            let $gallery_large = $element.find('.block-gallery-slider-large');
            if($element.hasClass('style-1')){
                $gallery_large.slick({
                    infinite: true,
                    rows:1,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    prevArrow: ".arrow-prev",
                    nextArrow: ".arrow-next",
                    dots: false,
                    responsive: [{
                        breakpoint: 992,
                        settings: {
                            rows: 1,
                            arrows: false,
                            dots: true,
                            slidesToShow: 2,
                            slidesToScroll: 1
                        }
                    },
                        {
                            breakpoint: 577,
                            settings: {
                                rows: 1,
                                dots: true,
                                arrows: false,
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                        }]
                });
                $('.block-magnifig').magnificPopup({
                delegate: 'a',
                type: 'image',
                gallery:{enabled:true},
                });
                $(function() {
                    var $img_popup = $element.find('.block-magnifig a');
                    var isDragging = false;
                    $('.block-gallery-slider-large .slick-slide' )
                        .mousedown(function() {
                            console.log('aaaa');
                            $(window).mousemove(function() {
                                isDragging = true;
                                $(window).unbind("mousemove");
                            });
                        })
                        .mouseup(function() {
                            var wasDragging = isDragging;
                            isDragging = false;
                            $(window).unbind("mousemove");
                            if(!wasDragging){
                                let $index = $(this).index();
                                $($img_popup[$index]).trigger('click');
                            }
                        })
                });
            }
            let person = plugin.settings.person;
            if($element.hasClass('style-3')){
                var n;
                function thumbImg(){
                    n =  8;
                    let width_window = window.innerWidth;
                    if(width_window < 1200 && width_window > 768){
                        n = 6;
                    }else if(width_window <= 768 && width_window > 320){
                        n = 5;
                    }else if(width_window <= 320){
                        n = 4;
                    }
                }
                thumbImg();
                $(window).resize(function(){
                    thumbImg();
                })
                let srcs = plugin.settings.srcs;
                console.log(srcs);
                let $space_Between = 10;
                var galleryTop = new Swiper('.gallery-top', {
                    spaceBetween:0,
                    loop: false,
                    navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    },
                    observer: true,
                    observeParents: true,
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                        renderBullet: function (index, className) {
                            let classClick = " ";
                            if(index == (n-1)) {
                                classClick = " click-in";
                            }
                            return '<a href="'+ srcs[index]+'" class="' + className + classClick + '"><div style="background-image: url('+srcs[index]+');"></div></a>';
                        },
                    },
                });
                let $swiper_wrapper = $element.find('.gallery-top .swiper-wrapper');
                let $swiper_wrapper_img = $swiper_wrapper.find('.img-block')
                let $gallery_top = $element.find('.gallery-top .swiper-slide');
                let $thumbs = $element.find('.swiper-pagination');
                let $thumbs_img = $thumbs.find('.swiper-pagination-bullet');
                let $thumbs_number = $('.swiper-pagination .swiper-pagination-bullet').length;




                function fixSize() {
                    $($thumbs_img).css('margin-right','0px')
                    for (let i = 0; i < (n-1);i++){
                        $($thumbs_img[i]).css('margin-right',''+ $space_Between +'px')
                    }
                    let $rest_thumbs_number = $thumbs_number - n;
                    $($thumbs_img.find('p.rest')).remove();
                    if ($rest_thumbs_number > 0){
                        $($thumbs_img[n-1]).append("<p class='rest'>+"+ $rest_thumbs_number +"</p>");
                    }
                    $($thumbs_img).removeClass('click-in');
                    $($thumbs_img[n-1]).addClass('click-in');
                    let $width_wrapper = $swiper_wrapper.width();
                    let $width_thumb = $thumbs.width();
                    $swiper_wrapper_img.height((2*$width_wrapper)/3);
                    $swiper_wrapper_img.width($width_wrapper);
                    let $size = ($width_thumb-(n-1)*10)/n
                    let $bottom = $size + 75;
                    // Set width,height thumbs
                    $thumbs_img.width($size);
                    $thumbs_img.height($size);
                    $thumbs.height($size);

                    $thumbs.css('bottom',''+ -$size - 10+'px')

                    $('.slide-detail').css('padding-bottom',''+ $bottom +'px')
                }
                fixSize();

                $(window).resize(function(){
                    fixSize();
                });

                $('a.click-in').on('click',function(){
                    var $this = $(this);
                    $(".swiper-pagination a").not(this).addClass('click-in');
                    $('.swiper-pagination').magnificPopup({
                        delegate: 'a.click-in',
                        type: 'image',
                        gallery:{enabled:true},
                        callbacks: {
                            close: function(){
                                $(".swiper-pagination a").not($this).removeClass('click-in');
                            }
                        }
                    });
                })
            }
            $element.find('.social-service li a').on('click',function(){
                window.open(this.href,this.title,'width=500,height=500,top=300px,left=300px');
                return false;
            })
            $element.find('.counter-minus').click(function (e) {
                person = $element.find('input[type="text"].increment-number').val();
                $element.find('.number-person').text(person);
                if (typeof event_choosen !== 'undefined') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                } else {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                }

            });
            $element.find('.counter-plus').click(function (e) {
                person = $element.find('input[type="text"].increment-number').val();
                $element.find('.number-person').text(person);
                if (typeof event_choosen !== 'undefined') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                } else {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                }
            });
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            let $employee_input = $element.find('input[name=employee_id]');
            $employee_input.on('change', function () {
                let employee_id = $(this).val();
                let list_employee = service_item.list_employee;
                let employee_choosen = list_employee.find(function (employee) {
                    if (employee.id == employee_id) {
                        return employee;
                    }
                });
                $element.find('.trainer-info').text(`${employee_choosen.first_name} ${employee_choosen.last_name}`)
            });

            let list_working_day = service_item.working_day;
            let array_day_by_number = [];
            if (typeof list_working_day !== 'undefined' && list_working_day !== null && list_working_day.trim() !== '') {
                list_working_day = JSON.parse(list_working_day);
                let week = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                let array_diff = plugin.arr_diff(list_working_day, week);
                let day_of_week = {
                    'Sunday': 0,
                    'Monday': 1,
                    'Tuesday': 2,
                    'Wednesday': 3,
                    'Thursday': 4,
                    'Friday': 5,
                    'Saturday': 6
                };
                for (const prop in day_of_week) {
                    for (let i = 0; i < array_diff.length; i++) {
                        if (prop === array_diff[i]) {
                            array_day_by_number.push(day_of_week[prop]);
                        }
                    }
                }
            }

            $element.find('.form_datetime').datetimepicker('setDaysOfWeekDisabled', array_day_by_number);
            $element.find('.time-booking').on('change', function () {
                let value = $(this).val();
                let time_start = moment(value).format('LT');
                let time_end = moment(value).add(service_item.duration, 'hour').format('LT');
                let date_book = moment(value).format('YYYY-MM-DD');
                if (value !== '') {
                    $element.find('.local-time').text(`${time_start} - ${time_end}`);
                    $element.find('.date-info').text(date_book);
                } else {
                    $element.find('.local-time').text('');
                    $element.find('.date-info').text('');
                }
            });

            $element.find('.btn-book-now-detail').click(function (e) {
                let $form = $(this).closest('form[name="client-form"]');
                let employee_id = $form.find('input[name="employee_id"]').val();
                if (employee_id === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    }, 500, "linear");
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Expert</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                let time_value = $form.find('.mirror_field').val();
                if (time_value === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    }, 500, "linear");
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    $('body,html').animate({
                        scrollTop: $element.find('.wrapper-block-check-out').offset().top
                    }, 500, "linear");
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-booknow').click(function () {
                let $block_event = $(this).closest('.block-event-item');
                $('body,html').animate({
                    scrollTop: $element.find('form.booking-form').offset().top
                }, 500, "linear");
                event_id = $block_event.data('event_id');
                event_choosen = list_event.find(function (event) {
                    if (event.id == event_id) {
                        return event;
                    }
                });
                $element.find('input[name="event_id"]').val(event_id);
                $element.find('.location-info').text(event_choosen.list_location[0].address)
                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price));
                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price));
            });


            $element.find('form[name="form-review"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-save-review').on('click', function () {
                let $form = $(this).closest('form[name="form-review"]');
                let rating_ambience = $form.find('input[name="rating_ambience"]').val();
                let rating_cleanliness = $form.find('input[name="rating_cleanliness"]').val();
                let rating_staff = $form.find('input[name="rating_staff"]').val();
                let rating_value = $form.find('input[name="rating_value"]').val();
                if(rating_ambience === '' || rating_cleanliness === '' || rating_staff === '' || rating_value === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please rating star</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    return false;
                }
                $form.submit();
            });

            let $wrapper_list_review = $element.find('.wrapper-list-review');
            let $render_list_review = $(plugin.settings.render_list_review);
            let $render_item_review = $render_list_review.filter('.block-review-item');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $render_item_review.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4): 4;

            $element.find('.pagination-review').twbsPagination({
                totalPages: (total_page === 0)?1:total_page ,
                visiblePages: visiblePages,
                hideOnlyOnePage:true,
                first: '',
                prev: '<i class="fas fa-arrow-left"></i>',
                next: '<i class="fas fa-arrow-right"></i>',
                last: '',
                onPageClick: function (event, page) {
                    var data_page = $render_item_review.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_list_review.empty();

                    $.each(data_page, function (index, review) {
                        $wrapper_list_review.append(review.outerHTML);
                    });

                }
            });
            $('body').on('click','.heart',function(e){
                let $service_item = $(this).closest('.category-name-heart');
                let service_id = $service_item.data('service_id');
                let user_id = $service_item.data('user_id');
                let $wishlist_icon = $(this);
                if(user_id==""){
                    if ( $('.alert-warning').length == 0){
                        $("body").append('<div class="alert alert-warning" role="alert" style="display: inline-block;position: fixed;right: 60px;top: 30px; z-index:99999;" >Please login to use the feature!<button type="button" class="close" data-dismiss="alert" aria-label="Close" style="margin-left: 30px"><span aria-hidden="true">&times;</span></button></div>');
                        setTimeout(function(){
                            $('.alert-warning').remove();
                        },1500)
                    }
                    return;
                }
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    service_id: service_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        if(!$wishlist_icon.hasClass("active")){
                            $wishlist_icon.find('i').hide();
                            $wishlist_icon.addClass('loading-item');
                        }
                        else{
                            $wishlist_icon.toggleClass('active');
                        }
                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        $wishlist_icon.find('i').show();
                        if($wishlist_icon.hasClass('loading-item')){
                            $wishlist_icon.toggleClass('active');
                        }
                        $wishlist_icon.removeClass('loading-item');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                    }
                });
            })
            $element.find('.my-choice').click(function (e) {
                $('.my-choice').not(this).removeClass('active');
                $(this).addClass('active')
            });
        };

        plugin.formatNumber = function (num) {
            return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
        };
        plugin.arr_diff = function (a1, a2) {
            let a = [], diff = [];
            if (a1.length > 0 && a2.length > 0) {
                for (let i = 0; i < a1.length; i++) {
                    a[a1[i]] = true;
                }
                for (let i = 0; i < a2.length; i++) {
                    if (a[a2[i]]) {
                        delete a[a2[i]];
                    } else {
                        a[a2[i]] = true;
                    }
                }
                for (let k in a) {
                    diff.push(k);
                }
            }
            return diff;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_service_detail = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_service_detail')) {
                let plugin = new $.view_service_detail(this, options);
                $(this).data('view_service_detail', plugin);
            }
        });
    }
})(jQuery);
