<?php
class WooPanel_Color_Swatches_Attributes {
    /**
	 * Class constructor.
	 */
	public function __construct() {
        add_action( 'admin_init', array( $this, 'init_attribute_hooks' ) );
    }

    public function init_attribute_hooks() {
        $attribute_taxonomies = wc_get_attribute_taxonomies();

		if ( empty( $attribute_taxonomies ) ) {
			return;
		}

		foreach ( $attribute_taxonomies as $tax ) {
			add_action( 'pa_' . esc_attr($tax->attribute_name) . '_add_form_fields', array( $this, 'add_attribute_fields' ) );
			add_action( 'pa_' . esc_attr($tax->attribute_name) . '_edit_form_fields', array( $this, 'edit_attribute_fields' ), 10, 2 );

			add_filter( 'manage_edit-pa_' . esc_attr($tax->attribute_name) . '_columns', array( $this, 'add_attribute_columns' ) );
			add_filter( 'manage_pa_' . esc_attr($tax->attribute_name) . '_custom_column', array( $this, 'add_attribute_column_content' ), 10, 3 );
		}

		add_action( 'created_term', array( $this, 'save_term_meta' ), 10, 2 );
		add_action( 'edit_term', array( $this, 'save_term_meta' ), 10, 2 );
    }
}

new WooPanel_Color_Swatches_Attributes();