<?php
/*
Plugin Name: WooCommerce - Vtiger CRM Syncing
Plugin URI:  http://www.vtigerwordpressintegration.com/product/woo-vtiger-syncing/
Description: Used to perform two way syncing between WooCommerce and vTiger CRM through API.
Version:     1.0.0
Author:      Technology Mindz
Author URI:  http://technologymindz.com/
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Domain Path: /languages
Text Domain: woo-vtiger-syncing
*/


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if ( is_plugin_active('woocommerce/woocommerce.php')) 
{  
	if(!class_exists('WooVtigerSync'))
	{
		class WooVtigerSync
		{
			/**
			 * Construct The Plugin Object
			 *
			*/
			public function __construct() {
				/* Activation hook */
				register_activation_hook(__FILE__, array($this, 'woo_vtiger_activate'));
			
				/* Deactivation hook */
				register_deactivation_hook(__FILE__, array(&$this, 'woo_vtiger_deactivate'));
	
				/* Set the constants needed by the plugin. */
				add_action( 'plugins_loaded', array( &$this, 'woo_vtiger_constants' ), 1 );
	
				/* Load the functions files. */
				add_action( 'plugins_loaded', array( &$this, 'woo_vtiger_includes' ), 2 );
	
				/* Add option in menu */
				add_action('admin_menu', 'add_custom_menu_option');
			}
	
			/**
			 * Defines constants used by the plugin.
			 *
			*/
			function woo_vtiger_constants() {
		
				/* Set constant path to the plugin directory. */
				define( 'WOO_VTIGER_DIR', trailingslashit(plugin_dir_path( __FILE__ )));

				/* Set constant path to the plugin URL. */
				define( 'WOO_VTIGER_URI', trailingslashit(plugin_dir_url( __FILE__ )));
				
				/* Set the constant path to the includes directory. */
				define( 'WOO_VTIGER_INCLUDES_DIR', WOO_VTIGER_DIR . trailingslashit( 'includes' ) );
	
				/* Set the constant path to the ui directory. */
				define( 'WOO_VTIGER_UI_DIR', WOO_VTIGER_DIR . trailingslashit( 'ui' ) );   
			}
			
			/**
			 * Loads the initial files needed by the plugin.
			 *
			**/
			function woo_vtiger_includes() {
				/* Load the plugin functions file. */
				require_once( 'woo-vtiger-function.php' );
			}
			
			/**
			 *  Activate the plugin
			 *
			**/
			public static function woo_vtiger_activate()
			{
				/* Include WP upgrade file for insert data. */
				require_once(ABSPATH . 'wp-admin/includes/upgrade.php' );
	
				global $wpdb;
	
				/* Create table to store last syncing date. */
				$table_name = $wpdb->prefix.'WVS_sync_date_info';
	
				if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name)
				{
					$sql = 'CREATE TABLE '.$table_name.'(
						id INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
						last_sync_date VARCHAR(255),
						module_type VARCHAR(255),
						description VARCHAR(255)
					);';
	
					dbDelta($sql);
	
					$wpdb->insert($table_name, array('id' => 1, 'last_sync_date' => '1975-01-01 00:00:00', 'module_type' => 'import products', 'description' => 'This is the last synchronize date when products import from vTigerCRM to WooCommerce.'));
					$wpdb->insert($table_name, array('id' => 2, 'last_sync_date' => '1975-01-01 00:00:00', 'module_type' => 'export products', 'description' => 'This is the last synchronize date when products export to vTigerCRM from WooCommerce.'));
					$wpdb->insert($table_name, array('id' => 3, 'last_sync_date' => '1975-01-01 00:00:00', 'module_type' => 'import contacts', 'description' => 'This is the last synchronize date when contacts import from vTigerCRM to WooCommerce.'));
					$wpdb->insert($table_name, array('id' => 4, 'last_sync_date' => '1975-01-01 00:00:00', 'module_type' => 'export contacts', 'description' => 'This is the last synchronize date when contacts export to vTigerCRM from WooCommerce.'));
					$wpdb->insert($table_name, array('id' => 5, 'last_sync_date' => '1975-01-01 00:00:00', 'module_type' => 'import orders', 'description' => 'This is the last synchronize date when sales orders import from vTigerCRM to WooCommerce.'));
					$wpdb->insert($table_name, array('id' => 6, 'last_sync_date' => '1975-01-01 00:00:00', 'module_type' => 'export orders', 'description' => 'This is the last synchronize date when sales orders export to vTigerCRM from WooCommerce.'));
				}
	
				/* Create table to store deleted products info from woocommerce. */
				$table_name = $wpdb->prefix.'WVS_deleted_product_info';
	
				if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name)
				{
					$sql = 'CREATE TABLE '.$table_name.'(
						id INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
						post_id INT(11),
						post_type VARCHAR(255),
						product_no VARCHAR(255),
						product_crm_id VARCHAR(255)
					);';
	
					dbDelta($sql);
				}
	
				/* Create table to store deleted contacts info from woocommerce. */
				$table_name = $wpdb->prefix.'WVS_deleted_contact_info';
	
				if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name)
				{
					$sql = 'CREATE TABLE '.$table_name.'(
						id INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
						user_id INT(11),
						contact_no VARCHAR(255),
						contact_crm_id VARCHAR(255)
					);';
	
					dbDelta($sql);
				}
	
				/* Create table to store deleted orders info from woocommerce. */
				$table_name = $wpdb->prefix.'WVS_deleted_order_info';
	
				if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name)
				{
					$sql = 'CREATE TABLE '.$table_name.'(
						id INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
						post_id INT(11),
						post_type VARCHAR(255),
						salesorder_no VARCHAR(255),
						salesorder_crm_id VARCHAR(255)
					);';
	
					dbDelta($sql);
				}
	
				/* Create table to store plugin front end info. */
				$table_name = $wpdb->prefix.'WVS_vtigercrm_login_info';
	
				if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name)
				{
					$sql = 'CREATE TABLE '.$table_name.'(
						id INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
						crm_endpointurl VARCHAR(255),
						crm_username VARCHAR(255),
						crm_access_key VARCHAR(255),
						crm_db_hostname VARCHAR(255),
						crm_db_username VARCHAR(255),
						crm_db_password VARCHAR(255),
						crm_db_name VARCHAR(255),
						crm_root_path VARCHAR(255)
					);';
	
					dbDelta($sql);
				}
				
				/* Create table to store last syncing time details. */
				$table_name = $wpdb->prefix.'WVS_last_sync_time_details';
	
				if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name)
				{
					$sql = 'CREATE TABLE '.$table_name.'(
						id INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
						sync_type VARCHAR(255),
						set_time VARCHAR(255),
						last_sync_time VARCHAR(255),
						description VARCHAR(255)
					);';
	
					dbDelta($sql);
					
					$wpdb->insert($table_name, array('id' => 1, 'sync_type' => 'start auto syncing', 'set_time' => 'null', 'last_sync_time' => '', 'description' => 'The last time auto syncing has been started' ));
					$wpdb->insert($table_name, array('id' => 2, 'sync_type' => 'stop auto syncing', 'set_time' => 'null', 'last_sync_time' => '',  'description' => 'The last time when auto syncing has been stopped.' ));
					$wpdb->insert($table_name, array('id' => 3, 'sync_type' => 'manually import products', 'set_time' => 'null', 'last_sync_time' => '',  'description' => 'The last synchronize time when products import from vtiger crm.' ));
					$wpdb->insert($table_name, array('id' => 4, 'sync_type' => 'manually export products', 'set_time' => 'null', 'last_sync_time' => '', 'description' => 'The last synchronize time when products export to vtiger crm.' ));
					$wpdb->insert($table_name, array('id' => 5, 'sync_type' => 'manually import contacts', 'set_time' => 'null', 'last_sync_time' => '',  'description' => 'The last synchronize time when customers import from vtiger crm.' ));
					$wpdb->insert($table_name, array('id' => 6, 'sync_type' => 'manually export orders', 'set_time' => 'null', 'last_sync_time' => '', 'description' => 'The last synchronize time when customers export to vtiger crm.' ));
					$wpdb->insert($table_name, array('id' => 7, 'sync_type' => 'manually import contacts', 'set_time' => 'null', 'last_sync_time' => '',  'description' => 'The last synchronize time when sales orders import from vtiger crm.'));
					$wpdb->insert($table_name, array('id' => 8, 'sync_type' => 'manually export orders', 'set_time' => 'null', 'last_sync_time' => '',  'description' => 'The last synchronize time when sales orders export to vtiger crm.' ));
					
				}
	
			}
	
			
			/**
			 *  Deactivation  Hook Of The Plugin
			 *
			**/
			public static function woo_vtiger_deactivate()
			{
				/* Drop All Tables */
				global $wpdb;
				
				$table_name = $wpdb->prefix.'WVS_sync_date_info';
				$drop_table = "DROP TABLE ".$table_name;
				$wpdb->query($drop_table);
				
				$table_name = $wpdb->prefix.'WVS_deleted_product_info';
				$drop_table = "DROP TABLE ".$table_name;
				$wpdb->query($drop_table);
				
				$table_name = $wpdb->prefix.'WVS_vtigercrm_login_info';
				$drop_table = "DROP TABLE ".$table_name;
				$wpdb->query($drop_table);
	
				$table_name = $wpdb->prefix.'WVS_deleted_contact_info';
				$drop_table = "DROP TABLE ".$table_name;
				$wpdb->query($drop_table);
	
				$table_name = $wpdb->prefix.'WVS_deleted_order_info';
				$drop_table = "DROP TABLE ".$table_name;
				$wpdb->query($drop_table);
				
				$table_name = $wpdb->prefix.'WVS_last_sync_time_details';
				$drop_table = "DROP TABLE ".$table_name;
				$wpdb->query($drop_table);
	
				stop_auto_syncing();
			}
		
		}
	}
	
	/* Instantiate the WooVtigerSync class */
	$ObjWooVtiger = new WooVtigerSync();
}
else
{
	echo '<div id="message" class="error"><p><strong>WooCommerce</strong> plugin is not activated. Please activate woocommerce plugin first.</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
    deactivate_plugins( plugin_basename( __FILE__ ) );		
    unset($_GET['activate']);
}




?>