<?php
    // get vtiger crm data information 
    $data = get_vtiger_crm_data_info();
    
    if( isset($_POST['save_crm_data'])) {
        // insert vtiger crm data information 
        insert_vtiger_data_into_table();
        $data = get_vtiger_crm_data_info();
    }
?>


<div class="wrap">
    
    <h1> Vtiger CRM Configuration Setting </h1>

    <form name="sync_form" method="post" action="">
        
        <table class="form-table">
            <tbody>
                
                <tr>
                    <th scope="row"><label for="crm_endpointurl"><?php _e("CRM Site Url" ); ?></label></th>
                    <td><input name="crm_endpointurl" type="text" id="crm_endpointurl" aria-describedby="tagline-description" value="<?php echo $data['crm_endpointurl']; ?>" class="regular-text" required>
                    <p class="description" id="tagline-description">Vtiger crm site url like http://vtiger_url/ </p></td>
                </tr>

                <tr>
                    <th scope="row"><label for="crm_root_path"><?php _e("CRM Root Path" ); ?></label></th>
                    <td><input name="crm_root_path" type="text" id="crm_root_path" aria-describedby="tagline-description" value="<?php echo $data['crm_root_path']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Vtiger crm root path like '/home/../../../crm folder name/'.</p></td>
                </tr>

                <tr>
                    <th scope="row"><label for="crm_db_hostname"><?php _e("Database Hostname" ); ?></label></th>
                    <td><input name="crm_db_hostname" type="text" id="crm_db_hostname" aria-describedby="tagline-description" value="<?php echo $data['crm_db_hostname']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Vtiger crm database hostname like : 'localhost'.</p></td>
                </tr>

                <tr>
                    <th scope="row"><label for="crm_db_username"><?php _e("Database Username" ); ?></label></th>
                    <td><input name="crm_db_username" type="text" id="crm_db_username" aria-describedby="tagline-description" value="<?php echo $data['crm_db_username']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Vtiger crm database username like : 'root'.</p></td>
                </tr>

                <tr>
                    <th scope="row"><label for="crm_db_password"><?php _e("Database Password" ); ?></label></th>
                    <td><input name="crm_db_password" type="password" id="crm_db_password" aria-describedby="tagline-description" value="<?php echo $data['crm_db_password']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Vtiger crm database password like '12345'.</p></td>
                </tr>

                <tr>
                    <th scope="row"><label for="crm_db_name"><?php _e("Database Name" ); ?></label></th>
                    <td><input name="crm_db_name" type="text" id="crm_db_name" aria-describedby="tagline-description" value="<?php echo $data['crm_db_name']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Vtiger crm database name like 'vtigercrm'.</p></td>
                </tr>

                <tr>
                    <th scope="row"><label for="crm_username"><?php _e("Username" ); ?></label></th>
                    <td><input name="crm_username" type="text" id="crm_username" aria-describedby="tagline-description" value="<?php echo $data['crm_username']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Username for crm "administrative" access (generally it is "admin"). </p></td>
                </tr>
            
                <tr>
                    <th scope="row"><label for="crm_access_key"><?php _e("User Access Key" ); ?></label></th>
                    <td><input name="crm_access_key" type="text" id="crm_access_key" aria-describedby="tagline-description" value="<?php echo $data['crm_access_key']; ?>" class="regular-text">
                    <p class="description" id="tagline-description">Access key of the crm "admin" user, found on my preferences page.</p></td>
                </tr>

            </tbody>
        </table>

        <p>
            Note : All the fields are mandatory. Before submit, please check all the fields are filled up and field value is correct.<br>
            If you have any confusion with above fields, please read the document attached with the plugin for reference purpose.
        </p>
        
        <p class="submit">
            <input type="submit" name="save_crm_data" id="save_crm_data" class="button button-primary" value="Submit">
        </p>

    </form>

</div>





