<?php
function nb_elementor_options( $pagebuilder, $options ) {
	$defaults = array(  
		'param_name'		=> '',
		'heading' 			=> '',
		'admin_label' 		=> false,
		'value' 			=> '',
		'std'				=> '',
		'edit_field_class' 	=> '',
		'dependency' 		=> '',
		'description'		=> '',
		'type'				=> 'text',
		'group'				=> '',
		'params'			=> '',
	);
	
	$html = array();

	if ( $pagebuilder == 'elementor' ) {
		if ( is_array( $options ) ) {
			foreach( $options as $key => $option ) {
				$option = wp_parse_args( $option, $defaults );

				if ( $option['param_name'] == '' ) continue;

				$condition = array();
				$depen = $option['dependency'];

				if ( $depen != '' ) {

					if ( isset( $depen['value_not_equal_to'] ) && $depen['value_not_equal_to'] != '' ) {
						// Switcher for Elementor
						if ( $depen['value_not_equal_to'] == 'true' || $depen['value_not_equal_to'] == '1' ) {
							$depen['value'] = 'yes';
						}
						elseif ( $depen['value_not_equal_to'] == 'false' || $depen['value_not_equal_to'] == '0' ) {
							$depen['value'] = 'no';
						}
						// End Switcher

						$condition[ $depen['element'] . '!' ] = $depen['value_not_equal_to'];
					} 
					else {
						// Switcher for Elementor
						if ( $depen['value'] == 'true' || $depen['value'] == '1' ) {
							$depen['value'] = 'yes';
						}
						elseif ( $depen['value'] == 'false' || $depen['value'] == '0' ) {
							$depen['value'] = 'no';
						}
						// End Switcher

						$condition[ $depen['element'] ] = $depen['value'];
					}
				}

				$arr_option = array();

				// Return options dropdown and more
				if ( isset( $option['value'] ) && ( is_array( $option['value'] ) || is_object($option['value']) ) && count( $option['value'] ) > 1 ) {		        	
					$arr_option = array_flip( $option['value'] );
				}

				// Return value
				if ( isset( $option['value'] ) ) {
					if ( $option['type'] == 'checkbox' ) {
						$option['std'] = ( $option['value'] = true ) ? 'yes' : 'no';
					}
					if ( $option['type'] == 'textfield' || $option['type'] == 'colorpicker' || $option['type'] == 'textarea' ) {
						$option['std'] = $option['value'];
					}
				}
				// End return values

				$html[$key]["id"] = $option['param_name'];
				
				// Type: Gallery
				if ( $option['type'] == 'attach_images' || $option['type'] == 'attach_image' || $option['type'] == 'vc_link' ) {
					$html[$key]["field"] = array(
						"label" => $option['heading'],
						"type" => $option['type'],
						"default" => [],
						"condition" => $condition,
						"description" => $option['description'],
					);
				}
				else {
					$html[$key]["field"] = array(
						"params" => $option['params'],
						"label" => $option['heading'],
						"type" => $option['type'],
						"options" => $arr_option,
						"default" => $option['std'],
						"condition" => $condition,
						"txt_default" => $option['value'],
						"description" => $option['description'],
					);
				}	
			}
		}
		
	} else {

		foreach( $options as $option ) {
			$html[] = $option;			
		}
	}

	return $html;
}

function nb_elementor_render( $name, $content ) {

	switch ( $name ) {
		// case 'Social Element':
		// 	echo NB_Social_Element::content( $content );
		// 	break;
		case 'Blog Element':
			echo NB_Blog_Element::content( $content );
			break;
		// case 'List Brands':
		// 	echo NB_Brands_Element::content( $content );
		// 	break;
		// case 'Heading Element':
		// 	echo NB_Heading_Element::content( $content );
		// 	break;
		 case 'Our Team':
		// 	echo NB_Ourteam_Element::content( $content );
		// 	break;
		case 'Product Online Design':
			echo NB_Product_Online_Design_Element::content( $content );
			break;
		// case 'Product Sliders':
		// 	echo NB_Product_Sliders::content( $content );
		// 	break;
		// case 'Template Online Design':
		// 	echo NB_Template_Online_Design_Element::content( $content );
		// 	break;
		case 'Timeline Simple Element':
			echo NB_Timeline_Element::content( $content );
			break;
		// case 'Contact Info Element':
		// 	echo NB_Contact_Info_Element::content( $content );
		// 	break;
		case 'Step Element':
			echo NB_Element_Step_Element::content( $content );
			break;
		case 'Feature Posts':
			echo NB_Feature_Post_Element::content( $content );
			break;
		// case 'Get to Know':
		// 	echo NB_Get_To_Element::content( $content );
		// 	break;
		// case 'Services Icon':
		// 	echo NB_Icon_Services_Element::content( $content );
		// 	break;
		case 'Image Banner':
			echo NB_Image_Banner_Element::content( $content );
			break;
		// case 'Instagram':
		// 	echo NB_Instagram_Element::content( $content );
		// 	break;
		// case 'Intro Image':
		// 	echo NB_Intro_Images_Element::content( $content );
		// 	break;
		case 'Leadership Team':
			echo NB_Leadership_Element::content( $content );
			break;
		case 'Map':
			echo NB_Map_Element::content( $content );
			break;
		// case 'Online Designer':
		// 	echo NB_Online_Design_Element::content( $content );
		// 	break;
		case 'Services':
			echo NB_Our_Service_Element::content( $content );
			break;
		// case 'NB: VC Step':
		// 	echo NB_Step_Element::content( $content );
		// 	break;
		// case 'Video':
		// 	echo NB_Video_Element::content( $content );
		// 	break;
		// case 'Product Hotdeals':
		// 	echo NB_Wc_Hotdeal_Element::content( $content );
		// 	break;
		// case 'List Products':
		// 	echo NB_Wc_List_Product_Element::content( $content );
		// 	break;
		case 'Product Tabs':
			echo NB_Product_Tabs_Element::content( $content );
			break;
		case 'Testimonials':
			echo NB_Testimonial_Element::content( $content );
			break;
		default:
			wp_die();
			break;
	}
}

function nb_elementor_get_type( $type ) {
    $args = array(
        'textarea' => \Elementor\Controls_Manager::TEXTAREA,
        'textfield' => \Elementor\Controls_Manager::TEXT,
        'textarea_html' => \Elementor\Controls_Manager::WYSIWYG,
        'dropdown' => \Elementor\Controls_Manager::SELECT,
        'checkbox' => \Elementor\Controls_Manager::SWITCHER,
        'param_group' => \Elementor\Controls_Manager::REPEATER,
        'attach_image' => \Elementor\Controls_Manager::MEDIA,
        'attach_images' => \Elementor\Controls_Manager::GALLERY,
        //'number'=>\Elementor\Controls_Manager::NUMBER,
        // 'posttypes'
        'colorpicker' => \Elementor\Controls_Manager::COLOR,
        'exploded_textarea' => \Elementor\Controls_Manager::CODE,
        // 'widgetised_sidebars'
        'textarea_raw_html' => \Elementor\Controls_Manager::CODE,
        'vc_link' => \Elementor\Controls_Manager::URL,
        // 'loop'
        // 'css_editor'
    );
    return isset( $args[$type] ) ? $args[$type] : Elementor\Controls_Manager::TEXTAREA;
}
?>