<?php

class NB_Feature_Post_Element {

	public function options() {
		$options = array(
        "name" => __( "Feature Posts", "printshop" ),
        "base" => "vc_printshop_feature",
        "class" => "",
        "category" => __( "PrintCart", "printshop"),
        "params" => array(
          array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __( "Title", "printshop" ),
            "param_name" => "vc_tab_title_post",
            "value" => 8,
          ),
          array(
            "type" => "textarea",
            "heading" => __( "Description", 'printshop' ),
            "param_name" => "description_post",
            "value" => __( "", 'printshop' ),
            "description" => __( "Enter description.", 'printshop'),
          ),
          array(
            'type' => 'param_group',
            'value' => '',
            'heading' => __('Lists', 'nb-fw'),
            'param_name' => 'add_vc_feature_lists',
            'group' => __('Content Options', 'nb-fw'),
            // Note params is mapped inside param-group:
            'params' => array(
                array(
                  "type" => "textfield",
                  "holder" => "div",
                  'group' => __('Content Options', 'nb-fw'),
                  "class" => "",
                  "heading" => __( "ID", "printshop" ),
                  "param_name" => "add_vc_feature_posts",
                  "value" => '',
              )
            )
          ),
          array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __( "Limit", "printshop" ),
            "param_name" => "vc_tab_product_limit",
            "value" => 8,
          )
        )
      );
		
		return $options;
	}

	public static function content( $atts ) {
		extract( shortcode_atts( array(
          'vc_tab_title_post' => '',
          'description_post' => '',
          'vc_tab_product_limit' => 8
      ), $atts ) );
    
    
      ob_start();

        if ( did_action( 'elementor/loaded' ) ) {
            $add_vc_feature_lists = $atts['add_vc_feature_lists'];
        }
        else {
            $add_vc_feature_lists = ( array ) vc_param_group_parse_atts( $atts['add_vc_feature_lists'] );
        }

      if ( $add_vc_feature_lists ) {
      ?>
      <div class="vc-getto-info">
          <div class="vc-getto-para">
            <h2 class="vc-heading-title"><?php echo $vc_tab_title_post; ?></h2>
            <?php echo $description_post; ?>
          </div>
    
          <div class="vc-getto-blog">
            <?php foreach ($add_vc_feature_lists as $key => $feature) {
                $feature_post = get_post($feature['add_vc_feature_posts']);
                $add_vc_feature_posts = wp_get_attachment_image_src(get_post_thumbnail_id( $feature['add_vc_feature_posts'] ), 'blog-thumb');
                ?>
                <div class="getblog-item">
                  <a href="<?php echo get_permalink($feature['add_vc_feature_posts']);?>" title="<?php echo esc_attr($feature_post->post_title);?>"><img src="<?php echo esc_url($add_vc_feature_posts[0]);?>" /></a> 
                  <div class="bg-getblog-item">
                      <h3><a href="<?php echo get_permalink($feature['add_vc_feature_posts']);?>" title="<?php echo esc_attr($feature_post->post_title);?>"><?php echo esc_attr(get_excerpt($feature_post->post_title, 5, '...'));?></a></h3>
                      <p><?php echo get_excerpt($feature_post->post_content, 30, '...');?></p>
                      <a href="<?php echo get_permalink($feature['add_vc_feature_posts']);?>" class="learn-more"><?php esc_html_e( 'Learn more', 'printshop' );?> <i class="long-arrow-right"></i></a>
                  </div>
                </div>
                <?php
            }?>
          </div>
      </div>
      <?php
      }
      
      return ob_get_clean();
	}
}
