<?php

class NB_Timeline_Element {

	public function options() {
		$options = array(
            'name' => esc_html__('Timeline Simple Element', 'nb-fw'),
            'base' => 'netbase_timeline_simple',
            'category' => esc_html__('PrintCart', 'nb-fw'),
            'description' => esc_html__('Display our team.', 'nb-fw'),
            'icon' => 'icon-wpb-wp',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'nb-fw'),
                    'param_name' => 'title',
                    'value' => '',
                ),

                array(
                        'heading'    => esc_html__( 'Our Team content', 'nb-fw' ),
                        'type'       => 'param_group',
                        'param_name' => 'timeline_simple_content',
                        'params'     => array(
                            array(
                                    'type' => 'dropdown',
                                    'heading' => __( 'Item Type', 'nb-fw' ),
                                    'param_name' => 'item_type',
                                    'value'       => array(
                                        __( 'Major Item', 'nb-fw' )   => 'major',
                                        __( 'Normal Item', 'nb-fw' ) => 'normal',
                                        __( 'Ending', 'nb-fw' ) => 'ending',
                                    ),
                            ),
                            
                            array(
                                'param_name' => 'avatar',
                                'heading'    => esc_html__( 'Avatar', 'nb-fw' ),
                                'type'       => 'attach_image',
                                'dependency'  => array(
                                    'element' => 'item_type',
                                    'value'   => 'normal',
                                ),
                            ),
                            array(
                                'param_name' => 'name',
                                'heading'    => esc_html__( 'Text', 'nb-fw' ),
                                'type'       => 'textfield',
                                'dependency'  => array(
                                    'element' => 'item_type',
                                    'value'   => 'normal',
                                ),
                            ),
                            array(
                                'param_name' => 'content',
                                'heading'    => esc_html__( 'Content', 'nb-fw' ),
                                'type'       => 'textarea',
                                
                            ),
                            
                            
                        ),
                    ),
                array(
                        'param_name' => 'avt_shape',
                        'heading'    => esc_html__( 'Avatar style', 'nb-fw' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Square', 'nb-fw' ) => 'square',
                            __( 'Circle', 'nb-fw' ) => 'circle',
                        ),
                        'std'        => 'circle',
                        'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                    ),
                array(
                        'param_name' => 'style',
                        'heading'    => esc_html__( 'Style', 'nb-fw' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Style 1', 'nb-fw' ) => 'style-1',
                            __( 'Style 2', 'nb-fw' ) => 'style-2',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                    ),             

                 

                
                array(
                    'heading'    => __( 'Extra class name', 'nb-fw' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-fw' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                )
            )
        );
		
		return $options;
	}

	public static function content( $atts ) {
		$html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'layout' => 'default',
                    'avatar'                => '',
                    'avt_shape'             => 'circle',
                    'timeline_simple_content' =>'',
                    'name'                  => '',
                    'style'                 => 'style-1',
                    
                    'item_type' =>'major',
                    'content' => '',    
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_timeline_simple_');

        $classes = $attr = array();
        $ifloat = 1;

       
        
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw timeline_simple" >';
        $html .= '<h2>'. $title . '</h2>';
        $html .= '<div class="timeline-bar" data-timeline="bar"></div>';

        if ( did_action( 'elementor/loaded' ) ) {
        	$values = $timeline_simple_content;
        }
        else {
        	$values = ( array ) vc_param_group_parse_atts( $timeline_simple_content );
        }

        $html .= '<ul class="timeline clearfix" data-timeline="element">';
        foreach ( $values as $key => $values ) {

        	if ( did_action( 'elementor/loaded' ) ) {
            		$image_link = $values[ 'avatar' ]['url'];
            	} else {
	                $img_id       = preg_replace( '/[^\d]/', '', $values[ 'avatar' ] );
	                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
	                $image_link   = $image[ 'p_img_large' ][ 0 ];
            	}

            if ( $values[ 'item_type']=='major' ) {
            $html .='<li class="timeline-items" data-timeline="items" data-direction="center" data-type="major"><div class="timeline-major"><div class="timeline-major-wrapper">'; 
            $html .= esc_html( $values[ 'content' ] );
            $html .='</div></div></li>';          
         
            }

            if ( $values[ 'item_type']=='ending' ) {
                $html .='<li class="timeline-items" data-timeline="items" data-direction="center" data-type="end"><div class="timeline-end"><div class="timeline-end-wrapper">'; 
            $html .= esc_html( $values[ 'content' ] );
            $html .='</div></div></li>';  
 
            }

            if($values[ 'item_type']=='normal'){
                $html .= '<li class="timeline-items">';                
                if($ifloat % 2==0){
                    $html .= '<div class="timeline-events item-right" data-timeline-content="normal">';
                }else{
                    $html .= '<div class="timeline-events item-left" data-timeline-content="normal">';
                }
                    
                    if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'nb-fw' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . '  />';
                        $html .= '</div>';
                    }

                    $html .= '<div class="content">';
                    if ( ! empty( $values[ 'name' ] ) ) {
                        $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                    }
                        $html .= '<div>' . $values[ 'content' ] . '</div>';
                    $html .= '</div>';                   
                    
                    
                $html .= '</div></li>';
                $ifloat ++;
            }
            
            
            
        }
        $html .= '<ul>'; 
        $html .= '</div>';       
        

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_timeline_simple', $html );
	}
}
