<?php

class NB_Testimonial_Element {

	public function options() {
		$options = array(
              "name" => __( "Testimonials", "printshop" ),
              "base" => "vc_printshop_testimonials",
              "class" => "",
              "category" => __( "PrintCart", "printshop"),
              "params" => array(
                 array(
                    "type" => "dropdown",
                    "heading" => __( "Style", "printshop" ),
                    "param_name" => "testimonial_style",
                    'value'      => array(                            
                        __( 'Multi Thumbnail', 'printshop' )      => 'multi_thumb',
                        __( 'Align Left', 'printshop' )      => 'align_left',
                        __( 'Single Small Thumbnail', 'printshop' )     => 'single_thumb',
                        __( 'Single Big Thumbnail', 'printshop' )     => 'single_big_thumb',
                        __( 'Cover Flow', 'printshop' )     => 'cover_flow',
                        __( 'Multi Block', 'printshop' )     => 'multi_block',
                        __( 'No Thumbnail', 'printshop' )     => 'no_thumb',
                    ),
                 ),

                 array(
                    'type' => 'param_group',
                    'value' => '',
                    'heading' => __('Testimonials Content', 'printshop'),
                    'param_name' => 'add_vc_testimonials_lists',
                    // Note params is mapped inside param-group:
                    'params' => array(
                       array(
                          "type" => "textfield",
                          "heading" => __( "Author name", "printshop" ),
                          "param_name" => "add_vc_our_testimonials_aname",
                          "value" => '',
                       ),
                       array(
                          "type" => "textfield",
                          "heading" => __( "Author position", "printshop" ),
                          "param_name" => "add_vc_our_testimonials_aposition",
                          "value" => '',
                       ),
                      array(
                          'type' => 'attach_image',
                          'heading' => __('Avatar', 'printshop'),
                          'param_name' => 'add_vc_our_testimonials_avatar',
                          'value' => '',
                          'description' => __('Select image from media library.', 'printshop'),
                          'admin_label' => true,
                       ),
                       array(
                          "type" => "textfield",
                          "heading" => __( "Title", "printshop" ),
                          "param_name" => "add_vc_our_testimonials_title",
                          "value" => '',
                       ),
                       array(
                          "type" => "textarea",
                          "heading" => __( "Content", "printshop" ),
                          "param_name" => "add_vc_our_testimonials_content",
                          "value" => '',
                       ),
                       array(
                          "type" => "textfield",
                          "heading" => __( "Posted date", "printshop" ),
                          "param_name" => "add_vc_our_testimonials_posted_date",
                          'description' => __('mm/dd/YYYY', 'printshop'),
                          "value" => date('m/d/Y'),
                       ),
                       array(
                           'type' => 'attach_image',
                           'heading' => __('Background Image', 'printshop'),
                           'param_name' => 'testimonial_bg',
                           'value' => '',
                           'description' => __('Select image from media library.', 'printshop'),
                           'admin_label' => true,
                        ),
                    )
                 ),

                 array(
                     'type' => 'checkbox',
                     'heading' => __( 'Show Navigation', 'printshop' ),
                     'param_name' => 'show_navigation',
                 ),

                 array(
                     'type' => 'checkbox',
                     'heading' => __( 'Show Pagination', 'printshop' ),
                     'param_name' => 'show_pagination',
                 ),
              )
           );
		
		return $options;
	}

	public static function content( $atts ) {
		extract( shortcode_atts( array(
           'testimonial_style' => 'multi_thumb',
           'add_vc_testimonials_lists' => '',
           'show_navigation' => '',
           'show_pagination' => '',
        ), $atts ) );

        ob_start();
        if ( did_action( 'elementor/loaded' ) ) {
                $testimonials_lists = $atts['add_vc_testimonials_lists'];
            }
            else {
                $testimonials_lists = ( array ) vc_param_group_parse_atts( $atts['add_vc_testimonials_lists'] );
            }
        $testimonial_data[] = array();

        foreach ( $testimonials_lists as $index => $item ) {

           $avatar_img_id = isset( $item['add_vc_our_testimonials_avatar'] ) ? $item['add_vc_our_testimonials_avatar'] : '';

           if ( did_action( 'elementor/loaded' ) ) {
           		$testimonial_data[$index]['img_src'] = $avatar_img_id['url'];
           }
           else {
	           	$img_data = wp_get_attachment_image_src( $avatar_img_id, 'thumbnail' );
           		$testimonial_data[$index]['img_src'] = $img_data[0];
           }


           $testimonial_data[$index]['title'] = isset( $item['add_vc_our_testimonials_title'] )? $item['add_vc_our_testimonials_title'] : '';

           $testimonial_data[$index]['content'] = isset( $item['add_vc_our_testimonials_content'] )? $item['add_vc_our_testimonials_content'] : '';

           $testimonial_data[$index]['name'] = isset( $item['add_vc_our_testimonials_aname'] ) ? $item['add_vc_our_testimonials_aname'] : '';

           $testimonial_data[$index]['position'] = isset( $item['add_vc_our_testimonials_aposition'] ) ? $item['add_vc_our_testimonials_aposition'] : '';

           $posted_date = isset( $item['add_vc_our_testimonials_posted_date'] ) ? $item['add_vc_our_testimonials_posted_date'] : '';

           $testimonial_data[$index]['posted_date'] = ( $posted_date !== '' ) ? date( 'F Y', strtotime( $posted_date ) ) : '';

           $background_img_id = isset( $item['testimonial_bg'] ) ? $item['testimonial_bg'] : '';

           if ( did_action( 'elementor/loaded' ) ) {
           		$testimonial_data[$index]['testimonial_bg_src'] = $background_img_id['url'];
           }
           else {
           		$background_img_data = wp_get_attachment_image_src( $background_img_id, 'full' );
           		$testimonial_data[$index]['testimonial_bg_src'] = $background_img_data[0];
           }
        }

        if(count($testimonial_data) > 0){

           $style_class = 'testimonial_' . $testimonial_style;

        
        ?>
           <div class="vc-printshop-testimonials">
              <div class="vc_testimonial_wrap <?php echo esc_attr($style_class);?>" data-style="<?php echo esc_attr($testimonial_style);?>">

                 <?php if( $testimonial_style == 'multi_thumb' ):?>

                    <div class="swiper-container vc-avatar-testimonial">
                       <div class="swiper-wrapper">
                          <?php foreach ($testimonial_data as $testimonial):?>
                             <div class="swiper-slide">
                                <div class="vc-avatar-img">
                                   <img src="<?php echo esc_url($testimonial['img_src']);?>" alt="<?php echo esc_html( $testimonial['name'] );?>" />
                                </div>
                             </div>
                          <?php endforeach;?>
                       </div>
                    </div>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                          <?php foreach ($testimonial_data as $testimonial) {?>
                          <div class="swiper-slide">
                             <div class="vc-testimonial-content">
                                <p class="description"><?php echo esc_html($testimonial['content']);?></p>
                                <p class="client-name"><?php echo esc_html( $testimonial['name'] );?></p>
                                <p class="client-position"><?php echo esc_html( $testimonial['position'] );?></p>
                             </div>

                          </div>
                          <?php }?>
                       </div>

                        <?php if($show_pagination):?>
                            <div class="testimonial-pagination"></div>
                        <?php endif;?>

                        <?php if($show_navigation):?>
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        <?php endif;?>
                    </div>

                 <?php elseif( $testimonial_style == 'single_thumb' ):?>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                          <?php foreach ($testimonial_data as $testimonial) :?>
                             <div class="swiper-slide">
                                <div class="vc-avatar-testimonial">
                                   
                                      <div class="vc-avatar-img">
                                         <img src="<?php echo esc_url($testimonial['img_src']);?>" alt="<?php echo esc_html( $testimonial['name'] );?>" />
                                      </div>
                                      <p class="client-name"><?php echo esc_html( $testimonial['name'] );?></p>
                                      <p class="client-position"><?php echo esc_html( $testimonial['position'] );?></p>
                                </div>

                                <div class="vc-testimonial-content">
                                   <p class="title"><?php echo $testimonial['title'];?></p>
                                   <p class="description"><?php echo $testimonial['content'];?></p>
                                </div>

                             </div>
                          <?php endforeach;?>
                       </div>

                        <?php if($show_pagination):?>
                            <div class="testimonial-pagination"></div>
                        <?php endif;?>

                        <?php if($show_navigation):?>
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        <?php endif;?>
                    </div>

                 <?php elseif( $testimonial_style == 'align_left' ):?>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                          <?php foreach ($testimonial_data as $testimonial) :?>
                             <div class="swiper-slide">

                                <div class="vc-testimonial-content">
                                   <p class="title"><?php echo $testimonial['title'];?></p>
                                   <p class="description"><?php echo $testimonial['content'];?></p>
                                </div>

                                <div class="vc-avatar-testimonial">
                                   
                                      <div class="vc-avatar-img">
                                         <img src="<?php echo esc_url($testimonial['img_src']);?>" alt="<?php echo esc_html( $testimonial['name'] );?>" />
                                      </div>
                                      <div class="client-data">
                                         <p class="client-name"><?php echo esc_html( $testimonial['name'] );?></p>
                                         <p class="client-position"><?php echo esc_html( $testimonial['position'] );?></p>
                                      </div>      
                                </div>


                             </div>
                          <?php endforeach;?>
                       </div>

                       <?php if($show_pagination):?>
                           <div class="testimonial-pagination"></div>
                       <?php endif;?>

                       <?php if($show_navigation):?>
                           <div class="swiper-button-next"></div>
                           <div class="swiper-button-prev"></div>
                       <?php endif;?>
                    </div>

                <?php elseif( $testimonial_style == 'cover_flow' ):?>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                          <?php foreach ($testimonial_data as $testimonial) :?>
                             <div class="swiper-slide">

                                <div class="vc-testimonial-content">
                                   <p class="description"><?php echo $testimonial['content'];?></p>
                                </div>

                                <div class="vc-avatar-testimonial">
                                   
                                      <div class="vc-avatar-img">
                                         <img src="<?php echo esc_url($testimonial['img_src']);?>" alt="<?php echo esc_html( $testimonial['name'] );?>" />
                                      </div>
                                      <div class="client-data">
                                         <p class="client-name"><?php echo esc_html( $testimonial['name'] );?></p>
                                         <p class="client-position"><?php echo esc_html( $testimonial['position'] );?><span class="posted-date"><?php echo $testimonial['posted_date'];?></span></p>
                                      </div>      
                                </div>


                             </div>
                          <?php endforeach;?>
                       </div>
                    </div>

                <?php elseif( $testimonial_style == 'multi_block' ):?>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) :?>
                                <?php
                                $testimonial_bg_class = !is_null($testimonial['testimonial_bg_src']) ? 'style="background:url(' . esc_url($testimonial['testimonial_bg_src']) . ')  0% 50% / cover no-repeat"' : '';
                                ?>
                                <div class="swiper-slide" <?php echo $testimonial_bg_class;?>>

                                    <div class="vc-testimonial-content">
                                       <p class="description"><?php echo $testimonial['content'];?></p>
                                    </div>

                                    <div class="vc-avatar-testimonial">
                                       
                                          <div class="vc-avatar-img">
                                             <img src="<?php echo esc_url($testimonial['img_src']);?>" alt="<?php echo esc_html( $testimonial['name'] );?>" />
                                          </div>
                                          <div class="client-data">
                                             <p class="client-name"><?php echo esc_html( $testimonial['name'] );?></p>
                                             <p class="client-position"><?php echo esc_html( $testimonial['position'] );?></p>
                                          </div>        
                                    </div>


                                </div>
                            <?php endforeach;?>
                       </div>

                       <?php if($show_pagination):?>
                           <div class="testimonial-pagination"></div>
                       <?php endif;?>

                       <?php if($show_navigation):?>
                           <div class="swiper-button-next"></div>
                           <div class="swiper-button-prev"></div>
                       <?php endif;?>
                    </div>

                <?php elseif( $testimonial_style == 'no_thumb' ):?>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                            <?php foreach ($testimonial_data as $testimonial) :?>
                                
                                <div class="swiper-slide">

                                    <div class="vc-avatar-testimonial">
                                       
                                          <div class="client-data">
                                             <p class="client-name"><?php echo esc_html( $testimonial['name'] );?></p>
                                             <p class="client-position"><?php echo esc_html( $testimonial['position'] );?></p>
                                          </div>        
                                    </div>

                                    <div class="vc-testimonial-content">
                                       <p class="description"><?php echo $testimonial['content'];?></p>
                                    </div>

                                </div>
                            <?php endforeach;?>
                       </div>

                       <?php if($show_pagination):?>
                           <div class="testimonial-pagination"></div>
                       <?php endif;?>

                       <?php if($show_navigation):?>
                           <div class="swiper-button-next"></div>
                           <div class="swiper-button-prev"></div>
                       <?php endif;?>
                    </div>
                
                <?php elseif( $testimonial_style == 'single_big_thumb' ):?>

                    <div class="swiper-container vc-content-testimonial">
                       <div class="swiper-wrapper">
                          <?php foreach ($testimonial_data as $testimonial) :?>
                             <div class="swiper-slide">
                                <div class="vc-avatar-testimonial">
                                      <div class="vc-avatar-img">
                                         <img src="<?php echo esc_url($testimonial['img_src']);?>" alt="<?php echo esc_html( $testimonial['name'] );?>" />
                                      </div>
                                </div>

                                <div class="vc-testimonial-content">
                                   <p class="description"><?php echo $testimonial['content'];?></p>
                                </div>
                                
                                <div class="testimonial-meta">
                                    <span class="client-name"><?php echo esc_html( $testimonial['name'] );?></span> /
                                    <span class="client-position"><?php echo esc_html( $testimonial['position'] );?></span>
                                </div>

                             </div>
                          <?php endforeach;?>
                       </div>

                        <?php if($show_pagination):?>
                            <div class="testimonial-pagination"></div>
                        <?php endif;?>

                        <?php if($show_navigation):?>
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        <?php endif;?>
                    </div>

                <?php endif;?>

              </div>
           </div>
        <?php
        }
        
        return ob_get_clean();
	}
}
