<?php

class NB_Product_Tabs_Element {

	public function options() {
		$terms = get_terms( array(
			'hide_empty' => false,
		) );            
		$output_categories["All Categories"] = "";

		if ( $terms ) {
			foreach( $terms as $key => $term ) {
				if ( $term->taxonomy == 'product_cat' ) {
					if ( is_object( $term ) ) {
						$output_categories[$term->name] = $term->slug;
					}
				}
			}
		}

		$options = array(
			"name" => __( "Product Tabs", "printshop" ),
			"base" => "vc_printshop_tab_product",
			"class" => "",
			"category" => __( "PrintCart", "printshop"),
			"params" => array(
				array(
					'type'          => 'dropdown',
					'heading'       => esc_html__( 'Product type', 'printshop' ),
					'param_name'    => 'product_type',
					'admin_label'   => true,
					'value'         => array(
						esc_html__('Recent', 'printshop')       => 'recent',
						esc_html__('Featured', 'printshop') => 'featured',
						esc_html__('Best Selling', 'printshop') => 'best_selling',
						esc_html__('Top Rated', 'printshop')    => 'top_rated',
						esc_html__('Mixed Order', 'printshop')  => 'mixed_order'
					),
					'description'   => esc_html__( 'Select type of product', 'printshop' ),
					'group'         =>'Content',
				),

				array(
					'type'          => 'param_group',
					'value'         => '',
					'heading'       => __('Product Categories', 'printshop'),
					'param_name'    => 'vc_tab_product_lists',
					'group'         =>'Content',
					'params'        => array(
						array(
							"type"          => "textfield",
							"holder"        => "div",
							"class"         => "",
							"heading"       => __( "Label", "printshop" ),
							"param_name"    => "vc_tab_product_label",
							"value"         => '',
						),
						array(
							'type'          => 'dropdown',
							'heading'       => __('Product Cat', 'printshop'),
							'param_name'    => 'vc_tab_product_cat',
							'value'         => $output_categories,
							'save_always'   => true,
							'admin_label'   => true,
							'dependency'    => array(
								'element'   => 'layout',
								'value_not_equal_to' => 'wp-list',
							),
						),
					)
				),
				array(
					"type"               => "dropdown",
					"heading"            => __( "Tab color", "printshop" ),
					"param_name"         => "tab_color",
					'group'              =>'Content',
					'value'              => array(                            
						__( 'Dark', 'printshop' )         => 'dark',
						__( 'Light', 'printshop' )        => 'light'
					),
				),
				array(
					"type"               => "dropdown",
					"heading"            => __( "Tab style", "printshop" ),
					"param_name"         => "tab_style",
					'group'              =>'Content',
					'value'              => array(                            
						__( 'Rounded', 'printshop' )         => 'rounded',
						__( 'Separated', 'printshop' )       => 'separated',
						__( 'Classic', 'printshop' )         => 'classic',
						__( 'Border bottom', 'printshop' )   => 'border_bottom',
					),
				),

				array(
					"type"               => "dropdown",
					"heading"            => __( "Tab align", "printshop" ),
					"param_name"         => "tab_title_align",
					'group'              =>'Content',
					'value'              => array(                            
						__( 'Center', 'printshop' )      => 'center',
						__( 'Left', 'printshop' )        => 'left',
						__( 'Right', 'printshop' )       => 'right'
					),
				),
				array(
					"type"          => "textfield",
					"holder"        => "div",
					"class"         => "",
					"heading"       => __( "Limit", "printshop" ),
					"param_name"    => "vc_tab_product_limit",
					'group'         =>'Content',
					"value"         => 8,
				),
				array(
					"type"           => "dropdown",
					"heading"        => __( "Column", "printshop" ),
					"param_name"     => "vc_tab_product_col",
					'std'            => 4,
					'group'          =>'Content',
					'value'          => array(                            
						__( '1', 'printshop' )       => 1,
						__( '2', 'printshop' )       => 2,
						__( '3', 'printshop' )       => 3,
						__( '4', 'printshop' )       => 4,
						__( '5', 'printshop' )       => 5,
					),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Heading', 'printshop' ),
					'param_name'  => 'heading_tab',
					'value'       => '',
					'group'       =>'Heading',
				),
				array(
					'type'        => 'colorpicker',
					'admin_label' => true,
					'heading'     => esc_html__( 'Heading Color', 'printshop' ),
					'param_name'  => 'heading_tab_color',
					'value'       => '',
					'group'       =>'Heading',
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Heading',
					"heading" => __( "Heading Font size", "printshop" ),
					"param_name" => "heading_font_size",
					"value" => '', 
					"description" => __( "Add heading font size ( Example: 15px or 15% )", "printshop" )
				),

				array(
					'type' => 'checkbox',
					'heading' => __( 'Show Heading Line', 'printshop' ),
					'param_name' => 'show_heading_line',
					'group'=>'Heading',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Sub Heading', 'printshop' ),
					'param_name'  => 'sub_heading_tab',
					'value'       => '',
					'group'       =>'Heading',
				),
				array(
					'type'        => 'colorpicker',
					'admin_label' => true,
					'heading'     => esc_html__( 'Sub Heading Color', 'printshop' ),
					'param_name'  => 'sub_heading_tab_color',
					'value'       => '',
					'group'       =>'Heading',
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Heading',
					"heading" => __( "Sub Heading Font size", "printshop" ),
					"param_name" => "sub_heading_font_size",
					"value" => '', 
					"description" => __( "Add sub heading font size ( Example: 15px or 15% )", "printshop" )
				),
				array(
					"type" => "textfield",
					"class" => "",
					'group'=>'Heading',
					"heading" => __( "Add text button", "printshop" ),
					"param_name" => "text_button",
					"value" => '', 
					"description" => __( "Add text button", "printshop" )
				),
			)
);

return $options;
}

public static function content( $atts ) {
	extract( shortcode_atts( array(
		'heading_tab'               => '',
		'heading_tab_color'         => '',
		'show_heading_line'         => '',
		'sub_heading_tab'           => '',
		'sub_heading_tab_color'     => '',
		'heading_font_size'         => '',
		'sub_heading_font_size'     => '',
		'tab_color'                 => 'dark',
		'tab_style'                 => 'rounded',
		'tab_title_align'           => 'center',
		'product_type'              => '',
		'vc_tab_product_lists'      => '',
		'vc_tab_product_limit'      => 8,
		'vc_tab_product_col'        => 4,
		'text_button'               => '',
	), $atts ) );

	ob_start();

	if ( did_action( 'elementor/loaded' ) ) {
		$vc_tab_product_lists = $vc_tab_product_lists;
	}
	else {
		$vc_tab_product_lists = ( array ) vc_param_group_parse_atts( $vc_tab_product_lists );
	}

        // Generate custom ID
	$product_tab_id = uniqid('product_tab_');

	if($vc_tab_product_lists):

		$columns = printcart_get_options('nbcore_loop_columns');

		if( $vc_tab_product_col == 4 ) {
			$columns = 'four-columns';
		} elseif( $vc_tab_product_col == 3 ) {
			$columns = 'three-columns';
		} elseif( $vc_tab_product_col == 2 ) {
			$columns = 'two-columns';
		} elseif( $vc_tab_product_col == 5 ) {
			$columns = 'five-columns';
		}

		$has_separated_border_class = printcart_get_options('nbcore_show_separated_border') ? 'has-separated-border' : '';


		$tab_title_align_class = 'align-' . $tab_title_align;
		$tab_style_class = 'style-' . $tab_style;
		$tab_color_class = $tab_color;

		$heading_tab_inline_css = $sub_heading_tab_inline_css = '';


		if($heading_tab_color != '') {
			$heading_tab_inline_css .= 'color: ' . $heading_tab_color . ';';
		}

		if($heading_font_size != '') {
			$heading_tab_inline_css .= 'font-size: ' . $heading_font_size . ';';
		}

		$heading_tab_css = $heading_tab_inline_css != '' ? 'style="' . $heading_tab_inline_css . '"' : '';


		if($sub_heading_tab_color != '') {
			$sub_heading_tab_inline_css .= 'color: ' . $sub_heading_tab_color . ';';
		}

		if($sub_heading_font_size != '') {
			$sub_heading_tab_inline_css .= 'font-size: ' . $sub_heading_font_size . ';';
		}

		$sub_heading_tab_css = $sub_heading_tab_inline_css != '' ? 'style="' . $sub_heading_tab_inline_css . '"' : '';


		$no_header_class = ($heading_tab == '' && $sub_heading_tab == '') ? 'no-heading' : '';

		$show_heading_line_class = $show_heading_line ? 'show_heading_line' : '';


		?>
		<div class="shop-main <?php echo esc_attr($columns)  . ' ' . esc_attr($has_separated_border_class);?>">
			<div class="vc-tab-product-wrapper">

				<div class="vc-tab-product-header">

					<?php if($heading_tab != '' || $sub_heading_tab != ''):?>
						<div class="product-tab-header <?php echo esc_attr($show_heading_line_class);?>">
							<?php if($sub_heading_tab != ''):?>
								<p <?php echo $sub_heading_tab_css;?>><?php echo esc_html($sub_heading_tab);?></p>
							<?php endif;?>

							<?php if($heading_tab != ''):?>
								<h2 <?php echo $heading_tab_css;?>><?php echo esc_html($heading_tab);?></h2>
							<?php endif;?>
						</div>
					<?php endif;?>

					<ul class="tab-label <?php echo esc_attr($tab_title_align_class);?> <?php echo esc_attr($tab_style_class);?> <?php echo esc_attr($tab_color_class);?> <?php echo esc_attr($no_header_class);?>">

						<?php 
						$div_content                = '';
						$first_tab_label            = '';
						$first_cat_img_align_class  = '';
						?>
						<?php foreach ($vc_tab_product_lists as $tab_key => $tab_value):

							$term                   = get_term_by( 'slug', $tab_value['vc_tab_product_cat'], 'product_cat' );
							$cat_name               = is_object($term) ? $term->name : esc_html__('All categories');
							$tab_label              = isset($tab_value['vc_tab_product_label']) ? $tab_value['vc_tab_product_label'] : $cat_name;
							$cat_images             = isset($tab_value['cat_img']) ? $tab_value['cat_img'] : '';
							$cat_img_align_class    = ! empty($tab_value['cat_img']) && ! empty($tab_value['cat_img_align']) ? 'img-align-' . $tab_value['cat_img_align'] : '';
							$cat_img_align          = isset($tab_value['cat_img_align']) ? $tab_value['cat_img_align'] : 'left';
							$cat_img_urls          = isset($tab_value['cat_img_url']) ? $tab_value['cat_img_url'] : '';

							if($tab_key == 0) {
								$first_tab_label = $tab_label;
								$first_cat_img_align_class = $cat_img_align_class;
							}
							else {
								$div_content .= '<div id="' . md5($product_tab_id.$tab_key.$tab_label).'" class="tab-panel ' . esc_attr($cat_img_align_class) . '" data-term_id="'.esc_attr($tab_value['vc_tab_product_cat']).'" data-limit="'.esc_attr($vc_tab_product_limit).'" data-product-type="'.esc_attr($product_type).'"></div>';
							}
							?>
							<li <?php if($tab_key == 0) echo 'class="active"';?>>
								<a href="#<?php echo md5($product_tab_id.$tab_key.$tab_label);?>"><?php echo esc_html($tab_label);?></a>
							</li>
						<?php endforeach;?>
					</ul>
				</div>

				<div class="vc-tab-product-content <?php echo esc_attr($tab_color_class);?>">

					<div id="<?php echo md5($product_tab_id.'0'.$first_tab_label);?>" class="tab-panel panel-active <?php echo esc_attr( $first_cat_img_align_class );?>" >
						<?php

						$product_cat = isset($vc_tab_product_lists[0]['vc_tab_product_cat']) ? $vc_tab_product_lists[0]['vc_tab_product_cat'] : '';

						$tab_args = array(
							'post_type' => 'product',
							'post_status' => 'publish',
							'product_cat' => $product_cat,
							'posts_per_page' => $vc_tab_product_limit
						);

						switch( $product_type ) {
							case 'sale':
							$tab_args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
							break;
							case 'featured':
							$tab_args['tax_query'][] = array(
								'taxonomy' => 'product_visibility',
								'field'    => 'name',
								'terms'    => 'featured',
								'operator' => 'IN',
							);
							break;
							case 'best_selling':
							$tab_args['meta_key']   = 'total_sales';
							$tab_args['orderby']    = 'meta_value_num';
							$tab_args['order']      = 'desc';
							break;
							case 'top_rated':
							$tab_args['meta_key']   = '_wc_average_rating';
							$tab_args['orderby']    = 'meta_value_num';
							$tab_args['order']      = 'desc';
							break;
							case 'mixed_order':
							$tab_args['orderby']    = 'rand';
							break;
							default: /* Recent */
							$tab_args['orderby']    = 'date';
							$tab_args['order']      = 'desc';
							break;
						}

						$tab_product = new WP_Query( $tab_args );

						if ( $tab_product->have_posts() ) :
							echo '<div class="products row grid-type">';

							while ( $tab_product->have_posts() ) : $tab_product->the_post();
								wc_get_template_part( 'content', 'product' );
							endwhile;

							echo '</div>';
						endif;
						wp_reset_postdata();
						?>
					</div>

					<?php print $div_content; ?>
				</div>
			</div>
		</div>

		<?php
	endif;

	return ob_get_clean();
}
}

function nb_yith_compare_buttons() {
	global $product;

	$button_text = get_option( 'yith_woocompare_button_text', __( 'Compare', 'yith-woocommerce-compare' ) );
	do_action ( 'wpml_register_single_string', 'Plugins', 'plugin_yit_compare_button_text', $button_text );
	$button_text = apply_filters( 'wpml_translate_single_string', $button_text, 'Plugins', 'plugin_yit_compare_button_text' );

	printf( '<a href="%s" class="%s" data-product_id="%d" rel="nofollow">%s</a>', get_permalink($product->get_id()), 'compare button bt-4', $product->get_id(), $button_text );

}
add_shortcode( 'yith_compare_buttons', 'nb_yith_compare_buttons');

function nb_register_product_tabs_route() {
	register_rest_route(
		'wp/v2',
		'/product_tabs',
		array(
			'methods'  => 'POST',
			'callback' => 'nb_rest_product_tabs_callback',
		)
	);
}
add_action( 'rest_api_init', 'nb_register_product_tabs_route' );

function nb_rest_product_tabs_callback( WP_REST_Request $request ) {
	$product_cat    = $request['cat'];
	$limit          = absint($request['limit']);
	$cat_imgs       = $request['cat_img'];
	$cat_img_urls   = $request['cat_img_urls'];
	$product_type   = $request['product_type'];

	$tab_args = array(
		'post_type' => 'product',
		'post_status' => 'publish',
		'product_cat' => $product_cat,
		'posts_per_page' => $limit
	);

	switch( $product_type ){
		case 'sale':
		$tab_args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
		break;
		case 'featured':
		$tab_args['tax_query'][] = array(
			'taxonomy' => 'product_visibility',
			'field'    => 'name',
			'terms'    => 'featured',
			'operator' => 'IN',
		);
		break;
		case 'best_selling':
		$tab_args['meta_key']   = 'total_sales';
		$tab_args['orderby']    = 'meta_value_num';
		$tab_args['order']      = 'desc';
		break;
		case 'top_rated':
		$tab_args['meta_key']   = '_wc_average_rating';
		$tab_args['orderby']    = 'meta_value_num';
		$tab_args['order']      = 'desc';
		break;
		case 'mixed_order':
		$tab_args['orderby']    = 'rand';
		break;
		default: /* Recent */
		$tab_args['orderby']    = 'date';
		$tab_args['order']      = 'desc';
		break;
	}

	$tab_product = new WP_Query( $tab_args );

	if ( $tab_product->have_posts() ) :
		echo '<div class="products row grid-type">';
		while ( $tab_product->have_posts() ) : $tab_product->the_post();

			wc_get_template_part( 'content', 'product' );

		endwhile;
		echo '</div>';
	endif;
	wp_reset_postdata();
	die();

}