<?php

class NB_Product_Sliders {

	public function options() {
		$args = array(
            'type' => 'post',
			'child_of' => 0,
			'parent' => '',
			'orderby' => 'parent',
			'order' => 'ASC',
			'hide_empty' => false,
			'hierarchical' => 1,
			'exclude' => '',
			'include' => '',
			'number' => '',
            'taxonomy' => 'product_cat',
            'pad_counts' => false,
        );
		$categories = get_categories( $args );

		$output_categories = array();
		$output_categories["All Categories"] = "";

		foreach( $categories as $category ) { 
			$output_categories[ wp_specialchars_decode( $category->name ) ] = $category->slug;
		}

		$options = array(
            "name" => esc_html__( "Product Sliders", "printshop" ),
            "base" => "vc_printshop_product_sliders",
            "class" => "",
            "category" => esc_html__( "PrintCart", "printshop"),
            "params" => array(
                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__( 'Product type', 'printshop' ),
                    'param_name'    => 'product_type',
                    'admin_label'   => true,
                    'value'         => array(
                            esc_html__('Recent', 'printshop')       => 'recent',
                            esc_html__('Featured', 'printshop') => 'featured',
                            esc_html__('Best Selling', 'printshop') => 'best_selling',
                            esc_html__('Top Rated', 'printshop')    => 'top_rated',
                            esc_html__('Mixed Order', 'printshop')  => 'mixed_order'
                            ),
                    'description'   => esc_html__( 'Select type of product', 'printshop' ),
                ),
                array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Product Cat", "nb_element" ),
					"param_name" => "product_cat",
					"description" => __('Category', 'nb_element'),
					"value" => $output_categories,
				),
                array(
                    "type"          => "textfield",
                    "holder"        => "div",
                    "class"         => "",
                    "heading"       => esc_html__( "Limit", "printshop" ),
                    "param_name"    => "product_limit",
                    "value"         => 8,
                ),
                array(
                   "type"           => "dropdown",
                   "heading"        => esc_html__( "Column", "printshop" ),
                   "param_name"     => "product_col",
                   'std'            => 4,
                   'value'          => array(
                       esc_html__( '2', 'printshop' )       => 2,
                       esc_html__( '3', 'printshop' )       => 3,
                   ),
                ),
            )
        );
		
		return $options;
	}

	public static function content( $atts ) {
		extract( shortcode_atts( array(
            'product_type'       => '',
            'product_cat'        => '',
            'product_limit'      => 8,
            'product_col'        => 2
        ), $atts ) );

        ob_start();

        ?>
        <div class="">
            <div class="vc-product-slider-wrapper swiper-container">
                <?php 

                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'product_cat' => $product_cat,
                    'posts_per_page' => $product_limit
                );

                switch( $product_type ){
		            case 'sale':
		                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
		            break;
		            case 'featured':
		                $args['tax_query'][] = array(
		                    'taxonomy' => 'product_visibility',
		                    'field'    => 'name',
		                    'terms'    => 'featured',
		                    'operator' => 'IN',
		                );
		            break;
		            case 'best_selling':
		                $args['meta_key']   = 'total_sales';
		                $args['orderby']    = 'meta_value_num';
		                $args['order']      = 'desc';
		            break;
		            case 'top_rated':
		                $args['meta_key']   = '_wc_average_rating';
		                $args['orderby']    = 'meta_value_num';
		                $args['order']      = 'desc';
		            break;
		            case 'mixed_order':
		                $args['orderby']    = 'rand';
		            break;
		            default: /* Recent */
		                $args['orderby']    = 'date';
		                $args['order']      = 'desc';
		            break;
		        }

                $products = new WP_Query( $args );

                if ( $products->have_posts() ) :
                    echo '<div class="products swiper-wrapper" data-column="' . $product_col . '">';
                    while ( $products->have_posts() ) : $products->the_post();
                ?>
                    <div class="product swiper-slide">
                        <div class="product-item">
                            <div class="product-thumb">
                                <a href="<?php echo esc_url(get_permalink());?>">
                                    <?php echo woocommerce_get_product_thumbnail();?>
                                </a>
                            </div>
                            <div class="product-meta">
                                <h4 class="product-title"><a href="<?php echo esc_url(get_permalink());?>"><?php echo esc_html(get_the_title());?></a></h4>
                                <p class="product-cats">
                                    <?php 
                                        $terms = get_the_terms( get_the_ID(), 'product_cat' );
                                        echo wc_get_product_category_list( get_the_ID(), ', ', '<span class="posted_in meta-name">' . _n( 'Category:', 'Categories:', count( $terms ), 'printshop' ) . ' </span><span>', '</span>' ); 
                                    ?>
                                </p>

                                <?php do_action( 'woocommerce_after_shop_loop_item_title' );?>
                            </div>
                        </div>
                    </div>

                <?php 
                    endwhile;
                    echo '</div>';
                    echo '<div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>';
                endif;
                wp_reset_postdata();

                ?>
            </div>
        </div>


         <?php
         
        return ob_get_clean();
	}
}
