<?php

class NB_Ourteam_Element {

	public function options() {
		$options = array(
            'name' => esc_html__('Our Team', 'nb_element'),
            'base' => 'netbase_our_team',
            'category' => esc_html__('PrintCart', 'nb-fw'),
            'description' => esc_html__('Display our team.', 'nb-fw'),
            'icon' => 'icon-wpb-wp',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'nb-fw'),
                    'param_name' => 'title',
                    'value' => '',
                ),
                array(
                    'heading'    => esc_html__( 'Our Team content', 'nb-fw' ),
                    'type'       => 'param_group',
                    'param_name' => 'our_team_content',
                    'params'     => array(
                        array(
                            'param_name' => 'avatar',
                            'heading'    => esc_html__( 'Avatar', 'nb-fw' ),
                            'type'       => 'attach_image',
                        ),
                        array(
                            'param_name' => 'description',
                            'heading'    => esc_html__( 'description', 'nb-fw' ),
                            'type'       => 'textarea',
                        ),
                        array(
                            'param_name' => 'name',
                            'heading'    => esc_html__( 'Name', 'nb-fw' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'job',
                            'heading'    => esc_html__( 'Job', 'nb-fw' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'facebook',
                            'heading'    => esc_html__( 'Facebook', 'nb-fw' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'twitter',
                            'heading'    => esc_html__( 'Twitter', 'nb-fw' ),
                            'type'       => 'textfield',
                        ),
                        array(
                            'param_name' => 'google_plus',
                            'heading'    => esc_html__( 'Google plus', 'nb-fw' ),
                            'type'       => 'textfield',
                        ),
                    ),
                ),
                array(
                    'param_name' => 'avt_shape',
                    'heading'    => esc_html__( 'Avatar style', 'nb-fw' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Square', 'nb-fw' ) => 'square',
                        __( 'Circle', 'nb-fw' ) => 'circle',
                    ),
                    'std'        => 'circle',
                    'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                ),
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Style', 'nb-fw' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Style 1', 'nb-fw' ) => 'style-1',
                        __( 'Style 2', 'nb-fw' ) => 'style-2',
                    ),
                    'edit_field_class' => 'vc_col-sm-6 mgt15',
                ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-fw'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),        
                array(
                    'param_name' => 'pagination',
                    'heading'    => esc_html__( 'Enable Pagination', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ), 
                array(
                    'param_name' => 'dots_size',
                    'heading'    => esc_html__( 'Dots Size', 'nb-fw' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        __( 'Big', 'nb-fw' ) => 'big',
                        __( 'Small', 'nb-fw' ) => 'small',
                    ),
                    'std'        => 'small',
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                    'edit_field_class' => 'vc_col-sm-6 vc_column mgt10',
                ), 
                array(
                    'param_name' => 'autoplay',
                    'heading'    => esc_html__( 'Enable Auto Play', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ), 
                array(
                    'param_name' => 'loop',
                    'heading'    => esc_html__( 'Enable Loop', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ),         

                array(
                    'param_name'  => 'columns',
                    'heading'     => esc_html__( 'Number of columns displayed', 'nb-fw' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( '1 column', 'nb-fw' )  => '1',
                        __( '2 columns', 'nb-fw' ) => '2',
                        __( '3 columns', 'nb-fw' ) => '3',
                        __( '4 columns', 'nb-fw' ) => '4',
                        __( '5 columns', 'nb-fw' ) => '5',
                        __( '6 columns', 'nb-fw' ) => '6',
                        __( '7 columns', 'nb-fw' ) => '7',
                        __( '8 columns', 'nb-fw' ) => '8',
                    ),
                    'std'         => '3',
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                    'param_name'  => 'columnstablet',
                    'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-fw' ),
                    'type'        => 'dropdown',
                    'value'       => array(
                        __( 'Select columns', 'nb-fw' )  => '',
                        __( '1 column', 'nb-fw' )  => '1',
                        __( '2 columns', 'nb-fw' ) => '2',
                        __( '3 columns', 'nb-fw' ) => '3',
                        __( '4 columns', 'nb-fw' ) => '4',
                        __( '5 columns', 'nb-fw' ) => '5',
                        __( '6 columns', 'nb-fw' ) => '6',
                        __( '7 columns', 'nb-fw' ) => '7',
                        __( '8 columns', 'nb-fw' ) => '8',
                    ),                     
                    'std'         => '',   
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'    => __( 'Extra class name', 'nb-fw' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-fw' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                )
            )
        );
		
		return $options;
	}

	public static function content( $atts ) {
		 $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'layout' => 'default',
                    'columns' => '3',                  
                    'columnstablet' =>'',  
                    'our_team_content'  => '',
                    'avatar'                => '',
                    'avt_shape'             => 'circle',
                    'description'           => '',
                    'name'                  => '',
                    'job'                   => '',
                    'facebook' =>'',
                    'twitter' => '',
                    'google_plus' => '',
                    'style'                 => 'style-1',
                    'slider'                => true,
                    'pagination'   => '',
                    'autoplay'     => '',
                    'loop'         => '', 
                    'dots_size' => 'small',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_our_team_');

        $classes = $attr = array();

        if ( ! empty( $slider ) ) {
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }
            if ( $autoplay ) {
                $attr[] = '"autoplay": "true"';
            }
            if ( $loop ) {
                $attr[] = '"loop": "true"';
            }
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }
            if ( $dots_size && $pagination ) {
                $classes[] =' dots-'.$dots_size.' ';
            }

            $classes[] = 'nb-fw-vccarousel owl-carousel owl-loaded owl-drag';
        }
        
        // Generate HTML code.
        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw our_team '. esc_attr( implode( ' ', $classes ) ) .'"  '.$data_owlcarousel.'>';
        

        if ( did_action( 'elementor/loaded' ) ) {
        	$values = $our_team_content;
        }
        else {
        	$values = ( array ) vc_param_group_parse_atts( $our_team_content );
        }

        foreach ( $values as $key => $values ) {

            // Get image link and image data
            if ( ! empty( $values[ 'avatar' ] ) ) {
            	if ( did_action( 'elementor/loaded' ) ) {
            		$image_link = $values[ 'avatar' ]['url'];
            	} else {
	                $img_id       = preg_replace( '/[^\d]/', '', $values[ 'avatar' ] );
	                $image        = wpb_getImageBySize( array( 'attach_id' => $img_id ) );
	                $image_link   = $image[ 'p_img_large' ][ 0 ];
            	}
            }
            
            $html .= '<div class="profile-item text-center">';
                    $html .= '<div class="author mgt20">';
                    if ( ! empty( $values[ 'avatar' ] )  ) {
                        $html .= '<div class="avatar">';
                            $html .= '<img src="' . esc_url( $image_link ) . '" alt="' .  ( ( ! empty( $values[ 'name' ] ) ) ?  esc_attr( $values[ 'name' ] ) : esc_attr__( 'Avatar', 'nb-fw' ) ) . '" ' . ( ( 'circle' == $avt_shape ) ? 'class="br-50"' : '' ) . '  />';
                        $html .= '</div>';
                    }
                        $html .= '<div class="ms-team-info">';
                        if ( ! empty( $values[ 'name' ] ) ) {
                            $html .= '<h3 class="name">' . esc_html( $values[ 'name' ] ) . '</h3>';
                        }

                        if ( ! empty( $values[ 'job' ] ) ) {
                            $html .= '<p class="job meta-color">' . esc_html( $values[ 'job' ] ) . '</p>';
                        }
                        $html .= '</div>';
                    $html .= '</div>';

                    $html .= '<div class="content">';
                        $html .= '<div>' . $values[ 'description' ] . '</div>';
                        if ( ! empty( $values[ 'facebook' ]) || ! empty( $values[ 'twitter' ]) || ! empty( $values[ 'google_plus' ] ) ) {
                        
                        $html .='<div class="ourteam-social-share">';
                            if ( ! empty( $values[ 'facebook' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'facebook' ] ) . '"><i class="fa fa-facebook"></i> </a>';
                            }
                            if ( ! empty( $values[ 'twitter' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'twitter' ] ) . '"><i class="fa fa-twitter"></i></a>';
                            }
                            if ( ! empty( $values[ 'google_plus' ] ) ) {
                                $html .= '<a href="' . esc_html( $values[ 'google_plus' ] ) . '"><i class="fa fa-google"></i> </a>';
                            }
                        $html .='</div>';
                        }
                    $html .= '</div>';
                
            $html .= '</div>';
            
        }

        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters( 'netbase_shortcode_our_team', $html );
	}
}
