<?php

class NB_Blog_Element {

	public function options() {

		$args = array(
			'type' => 'post',
			'child_of' => 0,
			'parent' => '',
			'orderby' => 'parent',
			'order' => 'ASC',
			'hide_empty' => false,
			'hierarchical' => 1,
			'exclude' => '',
			'include' => '',
			'number' => '',
			'taxonomy' => 'category',
			'pad_counts' => false,
		);
		$categories = get_categories( $args );
		$output_categories = array();

		$output_categories[ "All Categories" ] = "";

		foreach( $categories as $category ) { 
			$output_categories[ wp_specialchars_decode( $category->name ) ] = $category->slug;
		}

		$options = array(
			"name" => __( "Blog Element", "nb_element" ),
			"base" => "vc_blog_7",
			"class" => "",
			"category" => __( "PrintCart", "nb_element" ),
			'id' => 'vc_blog_7',
			'icon' => 'eicon-sidebar',
			"params" => array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Limit", "nb_element" ),
					"param_name" => "vc_tab_product_limit",
					"description" => __('Limit', 'nb_element'),
					"value" => 3,
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Category", "nb_element" ),
					"param_name" => "vc_category",
					"description" => __('Category', 'nb_element'),
					"value" => $output_categories,
				),
				array(
					"type" => "checkbox",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Excerpt", "nb_element" ),
					"param_name" => "vc_excerpt",
					"description" => __('Excerpt', 'nb_element'),
					"value" => 'false',
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Excerpt length", "nb_element" ),
					"param_name" => "vc_excerpt_length",
					"description" => __('Excrpt length', 'nb_element'),
					"value" => '',
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __( "Style blog", "nb_element" ),
					"param_name" => "vc_style_blog",
					"value" => array(
						__( "Style1", "nb_element" ) => 'Style1',
						__( "Style2", "nb_element" ) => 'Style2',
						__( "Style3", "nb_element" ) => 'Style3',
						__( "Style4", "nb_element" ) => 'Style4',
						__( "Style5", "nb_element" ) => 'Style5',
						__( "Style6", "nb_element" ) => 'Style6',
						__( "Style7", "nb_element" ) => 'Style7',
					), 
					"description" => __( "Style blog", "nb_element" )
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Post per slide ", "nb_element" ),
					"param_name" => "slider_per_page",
					"description" => __('', 'nb_element'),
					"value" => '2',
					'dependency' => array(
						'element' => 'vc_style_blog',
						'value'   => 'Style7',
					),
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Color caption", "nb-element" ),
					"param_name" => "vc_color_caption",
					"value" => '', 
					"description" => __( "Color caption blog", "nb-element" ),
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Color category", "nb-element" ),
					"param_name" => "vc_color_category",
					"value" => '', 
					"description" => __( "Color category blog", "nb-element" ),
					'dependency' => array(
						'element' => 'vc_style_blog',
						'value'   => array('Style6','Style7'),
					),
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Color description", "nb-element" ),
					"param_name" => "vc_color_description",
					"value" => '', 
					"description" => __( "Color description blog", "nb-element" ),
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Color detail", "nb-element" ),
					"param_name" => "vc_color_detail",
					"value" => '', 
					"description" => __( "Color detail blog", "nb-element" ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Blog sticky Padding Right", "nb_element" ),
					"param_name" => "style5_sticky_padding_right",
					"description" => __('Blog sticky Padding Right( Example: 15px or 15% )', 'nb_element'),
					"value" => '',
					'dependency' => array(
						'element' => 'vc_style_blog',
						'value'   => 'Style5',
					),
				),
			)
		);
		
		return $options;
	}

	public static function content( $atts ) {
		global $post;

		$caption = $category = $detail = $button = $description = $background = $color = '';
		extract( shortcode_atts( array(
			'vc_tab_product_limit' => 3,
			'vc_category'=>'',
			'vc_excerpt'=> 'yes',
			'vc_style_blog'=>'Style1',
			'vc_excerpt_length'=>'10',
			'style5_sticky_padding_right' =>'',
			'vc_color_caption' => '',
			'vc_color_category' => '',
			'vc_color_description' => '',
			'vc_color_detail' => '',
			'slider_per_page' => '2',
		), $atts ) );

		ob_start();

		$args = array(
			'posts_per_page'    => $vc_tab_product_limit,
			'post_type' => 'post',
			'category_name' => $vc_category,
		);

	   // The Query
		$the_query = new WP_Query( $args );

		if($vc_color_caption){
			$caption = ' style="color:'.$vc_color_caption.';"';
		}
		if($vc_color_category){
			$category = ' style="color:'.$vc_color_category.';"';
		}
		if($vc_color_description){
			$description = ' style="color:'.$vc_color_description.';"';
		}
		if($vc_color_detail){
			$detail = ' style="color:'.$vc_color_detail.';"';
		}

		// echo '<pre>';
		// print_r($vc_excerpt);
		// echo '</pre>';
		// die;
		if ( did_action( 'elementor/loaded' ) ) {
			$vc_excerpt = ( $vc_excerpt === 'yes' ) ? true : false;
		}
		

	  // The Loop
		if ( $the_query->have_posts() ) { ?>
			<?php 
			switch ($vc_style_blog) {
				case 'Style1':
				?>		

				<div class="vc-home-blog vc-blog">
					<?php
					while ( $the_query->have_posts() ) {
						$the_query->the_post();
						if ( has_post_thumbnail() ) {?>
							<article>
								<?php
								$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-rectangle' );
								if ( ! empty( $large_image_url[0] ) ) {
									echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
								}?>
								<div class="blog-content">
									<h4 class="caption" ><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo $post->post_title;?></a></h4>
									<div class="home-extra-detail">
										<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a> / </span> <span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
									</div>
									<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'...');}else{ echo $post->post_content ;}?> </p>
									<a href="<?php echo get_permalink( $post->ID );?>" class="hb-readmore">Read more</a>
								</div>
							</article>
							<?php 
						}
					}
					?>
				</div>

				<?php
				break;
				case 'Style2':
				?>

				<div class="vc-home-blog2 vc-blog">
					<?php
					$count=0;
					while ( $the_query->have_posts() ) {
						$count++;
						if($count % 3 == 1){
							echo '<div class="wrap">';
						}
						$the_query->the_post();
						if ( has_post_thumbnail() ) {?>
							<article class="art">
								<?php
								$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-rectangle' );
								if ( ! empty( $large_image_url[0] ) ) {
									echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
								}?>
								<div class="blog-content">
									<div class="home-extra-detail">
										<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a> / </span> <span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
									</div>
									<h4 class="caption"><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo $post->post_title;?></a></h4>
									<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'...');}else{ echo $post->post_content ;}?> </p>
								</div>
							</article>
							<?php 
						}
						if($count % 3 == 0){
							echo '</div>';
						}
					}
					?>
				</div>

				<?php	
				break;	
				case 'Style3':
				?>

				<div class="vc-home-blog3 vc-blog">
					<?php
					while ( $the_query->have_posts() ) {
						$the_query->the_post();
						if ( has_post_thumbnail() ) {?>
							<article class="art">
								<?php
								$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-rectangle' );
								if ( ! empty( $large_image_url[0] ) ) {
									echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
								}?>
								<div class="blog-content">
									<div class="home-extra-detail">
										<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a> / </span> <span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
									</div>
									<h4 class="caption"><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo $post->post_title;?></a></h4>
									<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'...');}else{ echo $post->post_content ;}?> </p>
									<a href="<?php echo get_permalink( $post->ID );?>" class="hb-readmore">Read more</a>
								</div>
							</article>
							<?php 
						}
					}
					?>
				</div>

				<?php
				break;
				case 'Style4':
				?>

				<div class="vc-home-blog4 vc-blog row">
					<?php
					while ( $the_query->have_posts() ) {
						$the_query->the_post();
						if ( has_post_thumbnail() ) {?>
							<article class="art col-lg-4 col-md-6">
								<?php
								$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-rectangle' );
								if ( ! empty( $large_image_url[0] ) ) {
									echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
								}?>
								<div class="blog-content">
									<div class="home-extra-detail">
										<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a>  /  </span><span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
									</div>
									<div class="caption"><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo get_excerpt($post->post_title, 10, '...');?></a></div>
									<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'...');}else{ echo $post->post_content ;}?> </p>
									<a href="<?php echo get_permalink( $post->ID );?>" class="hb-readmore">Read more<span <?php echo $background; ?>></span></a>
								</div>
							</article>
							<?php 
						}
					}
					?>
				</div>

				<?php
				break;
				case 'Style5':
				$custom_style = '';
				if($style5_sticky_padding_right){
					$custom_style = ' style="padding-right:'.$style5_sticky_padding_right.';"';
				}
				?>

				<div class="vc-home-blog5 vc-blog">
					<?php
					$count=0;
					while ( $the_query->have_posts() ) {
						$count++;
						if($count % 3 == 1){
							echo '<div class="wrap">';
						}
						if($count % 3 == 1){
							echo '<div class="wrap-child">';
						}
						$the_query->the_post();
						if ( has_post_thumbnail() ) {?>
							<article class="art" <?php if($count % 3 == 0){ echo $custom_style; } ?> >
								<?php
								if($count % 3 == 0){
									$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-masonry' );
								}else{
									$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-blog-home' );
								}

								if ( ! empty( $large_image_url[0] ) ) {
									echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
								}?>
								<div class="blog-content">
									<div class="caption"><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo $post->post_title;?></a></div>
									<div class="home-extra-detail">
										<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a> / </span> <span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
									</div>
									<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'...');}else{ echo $post->post_content ;}?> </p>
									<a href="<?php echo get_permalink( $post->ID );?>" class="hb-readmore">Read more</a>
								</div>
							</article>
							<?php 
						}
						if($count % 3 == 2){
							echo '</div>';
						}
						if($count % 3 == 0){
							echo '</div>';
						}
					}
					?>
				</div>

				<?php
				break;
				case 'Style6':
				?>
				<div class="vc-home-blog6 vc-blog row">
					<?php
					while ( $the_query->have_posts() ) {
						$the_query->the_post();
						if ( has_post_thumbnail() ) {?>
							<article class="col-lg-6">
								<?php
								$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-blog-home' );
								if ( ! empty( $large_image_url[0] ) ) {
									echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
								}?>
								<div class="blog-content">
									<div class="category" <?php echo $category ?>>Category: <?php $cate=get_the_category( $post->ID ) ;
									$i = 1;
									$count = count($cate);
									foreach($cate as $key => $value){
										echo $cate[$key]->name;
										if($i < $count){ echo ", "; }

										$i++;
									}
									?>
								</div>
								<h4 class="caption"><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo $post->post_title;?></a></h4>
								<div class="home-extra-detail">
									<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a> - </span> <span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
								</div>
								<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'');}else{ echo $post->post_content ;}?> </p>
								<a href="<?php echo get_permalink( $post->ID );?>" class="hb-readmore">Read More</a>
							</div>
						</article>
						<?php 
					}
				}
				?>
			</div>

			<?php
			break;

			case 'Style7':
			?>

			<div class="vc-home-blog7 vc-blog row">
				<div class="col-md-10 pad-left">
					<div class="swiper-container swiper6-content">
						<div class="swiper-wrapper">
							<?php
							$count=0;
							while ( $the_query->have_posts() ) {
								$count++;
								if($count % $slider_per_page == 1){
									echo '<div class="wrap swiper-slide">';
								}

								$the_query->the_post();
								if ( has_post_thumbnail() ) {?>
									<article class="art" >
										<?php
										$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'medium_large' );
										if ( ! empty( $large_image_url[0] ) ) {
											echo '<a class="home-blog-thumb" href="'. get_permalink( $post->ID ).'"><img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/></a>';
										}?>
										<div class="blog-content">
											<div class="category" <?php echo $category ?>>
												<?php 
												$cate=get_the_category( $post->ID ) ;
												$i = 1;
												$count1 = count($cate);
												foreach($cate as $key => $value){
													echo $cate[$key]->name;
													if($i < $count1){ echo ", "; }

													$i++;
												}
												?>
											</div>
											<div class="caption"><a <?php echo $caption ?> href="<?php echo esc_url( get_permalink($post->post_ID) );?>"><?php echo $post->post_title;?></a></div>
											<div class="home-extra-detail">
												<span <?php echo $detail ?>>By <a <?php echo $detail ?> href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a> / </span> <span <?php echo $detail ?>><?php echo get_the_date('M d, Y'); ?></span>
											</div>
											<p <?php echo $description ?>><?php if($vc_excerpt=='true'){echo get_excerpt($post->post_content, $vc_excerpt_length,'...');}else{ echo $post->post_content ;}?> </p>
											<a href="<?php echo get_permalink( $post->ID );?>" class="hb-readmore">Read more<span <?php echo $background; ?>></span></a>
										</div>
									</article>
									<?php 
								}
								if($count % $slider_per_page == 0 && $count != $vc_tab_product_limit){
									echo '</div>';
								}
							}
							?>
						</div>
					</div>
					<div class="swiper-button">
						<div class="swiper-next"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 44"><path d="M27,22L27,22L5,44l-2.1-2.1L22.8,22L2.9,2.1L5,0L27,22L27,22z"></svg></div>
							<div class="swiper-prev"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 44"><path d="M0,22L22,0l2.1,2.1L4.2,22l19.9,19.9L22,44L0,22L0,22L0,22z"></svg></div>
							</div>
						</div>
					</div>
				</div>

				<?php
				break;
			}

			wp_reset_postdata();
		}
		return ob_get_clean();
	}
}
