jQuery(document).ready(function ($) {

	"use strict";
//	$(document).on('vc-full-width-row', function() {

		$(".vc-printshop-testimonials").each(function(){

			var $this           = $(this);
			var dataStyle = $this.find( '.vc_testimonial_wrap' ).attr( 'data-style' );
			var styleClass = '.testimonial_' + dataStyle;
			
			if( dataStyle == 'multi_thumb' ) {

				var multiThumbATSelector = styleClass + ' .vc-avatar-testimonial';
				var multiThumbCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialAvatarSwiper = new Swiper(multiThumbATSelector, {
					grabCursor: true,
					initialSlide: 1,
					slidesPerView: 3,
					centeredSlides: true,
					slideToClickedSlide: true,
					breakpoints: {
					    480: {
					      slidesPerView: 1,
					    },
				  	},
				});

				var testimonialContentSwiper = new Swiper(multiThumbCTSelector, {
					grabCursor: true,
					initialSlide: 1,
					slidesPerView: 1,
					centeredSlides: true,
					pagination: {
					  	el: '.testimonial-pagination',
					  	clickable: true,
					},
					navigation: {
				        nextEl: '.swiper-button-next',
				        prevEl: '.swiper-button-prev',
			      	},
				});

				testimonialAvatarSwiper.on( 'slideChange', function () {

					var currentIndex = testimonialAvatarSwiper.activeIndex;
				  	testimonialContentSwiper.slideTo( currentIndex, 300, false );

				});

				testimonialContentSwiper.on('slideChange', function () {

					var currentIndex = testimonialContentSwiper.activeIndex;		
				  	testimonialAvatarSwiper.slideTo( currentIndex, 300, false );

				});

			}
			else if( dataStyle == 'single_thumb' ) {

				var singleThumbCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialContentSwiper = new Swiper(singleThumbCTSelector, {
					grabCursor: true,
					slidesPerView: 1,
					centeredSlides: true,
					pagination: {
					  	el: '.testimonial-pagination',
					  	clickable: true,
					},
					navigation: {
				        nextEl: '.swiper-button-next',
				        prevEl: '.swiper-button-prev',
			      	},
				});
			}
			else if( dataStyle == 'align_left' ) {

				var alignLefCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialContentSwiper = new Swiper(alignLefCTSelector, {
					grabCursor: true,
					slidesPerView: 1,
					centeredSlides: true,
					pagination: {
					  	el: '.testimonial-pagination',
					  	clickable: true,
					},
					navigation: {
				        nextEl: '.swiper-button-next',
				        prevEl: '.swiper-button-prev',
			      	},
				});
			}
			else if( dataStyle == 'cover_flow' ) {

				var coverFlowCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialContentSwiper = new Swiper(coverFlowCTSelector, {

					effect: 'coverflow',
				  	direction: 'vertical',
					loop: false,
					slideToClickedSlide: true,
					grabCursor: true,
					initialSlide: 1,
					centeredSlides: true,
					slidesPerView: 'auto',
					coverflowEffect: {
						rotate: 0,
						stretch: -44,
						depth: 530,
						modifier: 1,
						slideShadows: false
					},
					freeMode:false,
					freeModeSticky:true
				});
			}
			else if(dataStyle == 'multi_block') {

				var multiBlockCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialContentSwiper = new Swiper(multiBlockCTSelector, {
					grabCursor: true,
					slidesPerView: 3,
					spaceBetween: 30,
					pagination: {
					  	el: '.testimonial-pagination',
					  	clickable: true,
					},
					navigation: {
				        nextEl: '.swiper-button-next',
				        prevEl: '.swiper-button-prev',
			      	},
		      		breakpoints: {
		      		    991: {
		      		      slidesPerView: 2,
		      		    },
		      		    575: {
      		    	      slidesPerView: 1,
      		    	    },
		      	  	},
				});
			}

			else if(dataStyle == 'no_thumb') {

				var noThumbCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialContentSwiper = new Swiper(noThumbCTSelector, {
					grabCursor: true,
					slidesPerView: 1,
					pagination: {
					  	el: '.testimonial-pagination',
					  	clickable: true,
					},
					navigation: {
				        nextEl: '.swiper-button-next',
				        prevEl: '.swiper-button-prev',
			      	},
				});
			}
			else if( dataStyle == 'single_big_thumb' ) {

				var singleBigThumbCTSelector = styleClass + ' .vc-content-testimonial';

				var testimonialContentSwiper = new Swiper(singleBigThumbCTSelector, {
					grabCursor: true,
					slidesPerView: 1,
					centeredSlides: true,
					pagination: {
					  	el: '.testimonial-pagination',
					  	clickable: true,
					},
					navigation: {
				        nextEl: '.swiper-button-next',
				        prevEl: '.swiper-button-prev',
			      	},
				});
			}
		});
	//});
});