<?php
$nb_notification_unread = get_option('nb_notification_unread');
if( ! $nb_notification_unread ) {
	$nb_notification_unread = 0;
}

$nb_notification = get_option('nb_notification');
if( ! $nb_notification ) {
	$nb_notification = 0;
}?>


	<div id="pc-admin-header">
		<div class="pc-admin-header-row">
			<div class="pc-admin-header-search">
				<div class="pc-menu-toggle flyout-hamburger">
				    <span></span>
					<span></span>
					<span></span>
				</div>

				<ul>
					<?php if( ! empty($nodes_update) && preg_match('/<span class="ab-label">([0-9]+)<\/span>/', $nodes_update->title, $output_array)) {?>
					<li>
						<a href="<?php echo esc_url($nodes_update->href);?>" title="<?php echo $nodes_update->meta['title'];?>">
							<i class="adminpanel-icon-reload-symbol"></i>
							<span class="left-top-label"><?php echo $output_array[1];?></span>
						</a>
					</li>
					<?php }?>

					<?php if( preg_match('/<span class="ab-label(.*)" aria-hidden="true">([0-9]+)<\/span>/', $nodes_comments->title, $ncomment)) {?>
					<li>
						<a href="<?php echo esc_url($nodes_comments->href);?>">
							<i class="adminpanel-icon-chat"></i>
							<span class="left-top-label"><?php echo $ncomment[2];?></span>
						</a>
					</li>
					<?php }?>

					<?php if(preg_match('/<span class="ab-label">(.*?)<\/span>/', $nodes['new-content']->title, $new_content)) {?>
					<li class="new_content">
						<a href="<?php echo $nodes['new-content']->href;?>">
							<i class="adminpanel-icon-add-plus-button"></i>
							<span class="left-top-label"><?php echo $new_content[1];?></span>
						</a>

						<ul class="new-content-sub">
							<?php foreach( $node_new_posts as $k => $new ) {?>
							<li><a href="<?php echo $new->href;?>" title="<?php echo $new->title;?>"><?php echo $new->title;?></a></li>
							<?php }?>
						</ul>
					</li>
					<?php }?>
					
					<?php
					$screen = get_current_screen();
					if( ! empty($screen) && $screen->base == 'post' && isset($_GET['post']) ) {?>
					<li class="wp-admin-bar-view">
						<a href="<?php echo get_permalink($_GET['post']);?>" target="_blank">
							<i class="adminpanel-icon-eye"></i>
							<span class="left-top-label"><?php
							if( $screen->post_type == 'page' ) {
								_e('View Page');
							}elseif( $screen->post_type == 'post' ) {
								_e('View Post');
							}elseif( $screen->post_type == 'product' ){
								_e('View Product');
							}?></span>
						</a>
					</li>
					<?php }?>

					<?php if( isset($nodes['autoptimize']) ) {
						if(preg_match('/<span class="ab-label">(.*?)<\/span>/', $nodes['autoptimize']->title, $autoptimize)) {?>
						<li id="wp-admin-bar-<?php echo $nodes['autoptimize']->id;?>">
							<a href="<?php echo $nodes['autoptimize']->href;?>" title="<?php echo $autoptimize[1];?>">
								<i class="adminpanel-icon-circle-shape-outline"></i>
								<span class="left-top-label"><?php echo $autoptimize[1];?></span>
							</a>

							<ul id="wp-admin-bar-<?php echo $nodes['autoptimize']->id;?>-default" class="new-content-sub">
								<?php foreach( $node_new_autoptimize as $k => $new ) {?>
								<li id="wp-admin-bar-<?php echo $new->id;?>"><?php echo $new->title;?></li>
								<?php }?>
							</ul>
						</li>
						<?php }
					}?>
				</ul>

			</div>

			<div class="pc-admin-header-nav">
				<ul>
					<li class="pc-header-search">
						<a href="<?php echo home_url();?>" target="_blank"><i class="adminpanel-icon-search"></i></a>
						<form class="pc-admin-form">
							<input type="text" id="admin-search" name="search" placeholder="Search Order ID..." />
							<i class="adminpanel-icon-search"></i>
							<img class="adminpanel-icon-sloading" src="<?php echo NBDB_ABSURL;?>assets/images/spin-1s-30px.gif">
							<div class="nbd-search-rs">
								<ul>

								</ul>
							</div>
						</form>
					</li>
					<li class="pc-notifications" data-count="<?php echo $nb_notification_unread;?>">
						<a href="javascript:;" target="_blank"><i class="adminpanel-icon-bell"></i><span class="pc-notifications-count"><?php echo $nb_notification_unread;?></span></a>
						<div class="pc-notifications-submenu">
							<h4 class="pc-notifications-heading"><?php _e('Notifications', 'nb-dashboard');?> (<?php echo $nb_notification;?>)</h4>
							<div class="pc-notifications-scroll">
								<ul>
									<?php
									if( $notification_lists ) {
										$index = 0;
										foreach( $notification_lists as  $k => $notification ) {
											if( ! empty($notification['desc']) ) {?>
											<li attr-id="<?php echo $notification['id'];?>">
												<div class="pc-notifications-icon">
													<i class="<?php echo $notification['icon'];?>"></i>
												</div>
												
												<div class="pc-notifications-right">
													<a href="<?php echo $notification['link'];?>">
														<h4><?php echo $notification['title'];?></h4>
														<p><?php echo $notification['desc'];?></p>
													</a>
												</div>
											</li>
										<?php $index += 1;
											}
										}

										if( ! $index ) {
											?>
											<li class="pc-notifications-empty">
												<?php _e('No notification', 'nb-dashboard');?>
											</li>
											<?php
											update_option('nb_notification', 0);
										}
									}else {?>
									<li class="pc-notifications-empty">
										<?php _e('No notification', 'nb-dashboard');?>
									</li>
									<?php }?>
								</ul>
							</div>
						</div>
					</li>
					<li class="new-tab"><a href="<?php echo home_url();?>" target="_blank"><i class="adminpanel-icon-link-ext"></i></a></li>
					<li class="pc-has-submenu pc-admin-header-avatar">
						<img src="<?php echo get_avatar_url( $current_user->ID );?>" class="pc-avatar-main pc-has-sublink" />
						<div class="pc-admin-header-name pc-avatar-main pc-has-sublink">
							<a href="#"><?php echo $current_user->display_name;?></a>
							<p><?php echo ucfirst($current_user->roles[0]);?></p>
						</div>

						<div class="pc-admin-header-wrapper admin-submenu">
							<div class="pc-admin-profiles">
								<img src="<?php echo get_avatar_url( $current_user->ID );?>" />
								<div class="pc-admin-profiles-wrap">
									<h3><?php echo $current_user->display_name;?></h3>
									<p><?php echo $current_user->user_email;?></p>
								</div>
							</div>
							<ul class="pc-admin-profiles-menu">
								<li><a href="<?php echo admin_url('profile.php');?>">
									<i class="adminpanel-icon-user-pt"></i> Account Settings</a></li>
								<!--<li><a href="#"><i class="adminpanel-icon-gemstone"></i> Premium Plans</a></li>
								<li><a href="#"><i class="adminpanel-icon-message"></i> Inbox</a></li>
								<li><a href="#"><i class="adminpanel-icon-smartphone"></i> Billing & Payments</a></li>
								<li><a href="#"><i class="adminpanel-icon-coupon"></i> Vouchers</a></li>
								<li class="dev"></li>
								<li><a href="#"><i class="adminpanel-icon-info"></i> Help Center</a></li>
								<li><a href="#"><i class="adminpanel-icon-loop2"></i> Update and Releases</a></li>
								<li><a href="#"><i class="adminpanel-icon-language"></i> Language</a></li>-->
								<li><a href="#" class="link-logout"><i class="adminpanel-icon-exit_to_app"></i> Logout</a></li>

							</ul>
						</div>
					</li>
				</ul>
			</div>
		</div>
	</div>