<?php
// Check active Woocommerce 
$all_plugins = apply_filters('active_plugins', get_option('active_plugins'));
if (stripos(implode($all_plugins), 'woocommerce.php')) {
class NB_Dashboard_Widget {

	public $query_recent_orders;
	public $query_recent_orders_unpaid;
	public $query_seller;

	public function __construct() {
		add_action( 'admin_init', array($this, 'admin_init') );
		add_action( 'nb_dashboard_widget_loop_begin', array( $this, 'begin_loop'), 10, 2);
		add_action( 'nb_dashboard_widget_loop_end', array( $this, 'end_loop'), 10, 2);

		add_action( 'wp_dashboard_setup', array( $this, 'add_dashboard_widgets' ) );
		add_action( 'netbase_dashboard_title_widget', array($this, 'netbase_dashboard_title_widget'), 10, 1 );

		add_action( 'wp_ajax_netbase_dashboard_save_order', array( $this, 'netbase_dashboard_save_order') );

		add_filter( 'submenu_file', array($this, 'set_submenu_file'), 9999, 2);
		add_filter( 'parent_file', array($this, 'set_parent_file'), 9999, 1);

	}

	public function set_submenu_file($submenu_file, $parent_file) {
		if( isset($_GET['page']) && $_GET['page'] == 'netbase-dashboard' ) {
			$submenu_file = 'admin.php?page=netbase-dashboard';
		}

		return $submenu_file;
	}

	public function set_parent_file($parent_file) {
		global $parent_file;

		if( strpos($_SERVER['REQUEST_URI'], 'update-core.php') !== false ) {
			$parent_file = 'netbase-dashboard';
		}

		return $parent_file;
	}

	public function netbase_dashboard_save_order() {
		check_ajax_referer( 'meta-box-order' );

		if ( ! $user = wp_get_current_user() ) {
			wp_die( -1 );
		}

		if( isset($_POST['order']) ) {
			update_user_option( $user->ID, "meta-box-order_" . $_POST['page'], explode(',', $_POST['order']), true );
		}
		

		wp_die(1);
	}

	public function admin_init() {

		$this->query_recent_orders = new WP_Query( array(
			'posts_per_page' => 6,
			'post_type'   => wc_get_order_types(),
			'post_status' => array_keys( wc_get_order_statuses() )
		) );

		$unpaid_status = wc_get_order_statuses();
		$unpaid_status = array(
			'wc-on-hold' => $unpaid_status['wc-on-hold'],
			'wc-processing' => $unpaid_status['wc-processing'],
			'wc-pending' => $unpaid_status['wc-pending'],
			
		);
		$this->query_recent_orders_unpaid = new WP_Query( array(
			'posts_per_page' => 6,
			'post_type'   => wc_get_order_types(),
			'post_status' => array_keys( $unpaid_status )
		) );
	}
	
	public function begin_loop( $key, $widget ) {
		printf( '<div id="%s" class="admin-dashboard-boxed"><div class="admin-dashboard-wrapper">', $widget['id'] );
		echo '<div class="admin-dashboard-heading">';
		printf( '<h3 class="heading-title">%s</h3>', $widget['title'] );

		do_action('netbase_dashboard_title_widget', $key);

		echo '</div>';
		echo '<div class="admin-dashboard-content">';
	}
	
	public function end_loop( $key, $widget ) {
		echo '</div></div></div>';
	}

	public function add_dashboard_widgets() {
		global $wp_meta_boxes;

		if( class_exists('WooCommerce') ) {
			wp_add_dashboard_widget('netbase_dashboard_order_widgets', __('Orders', 'nb-dashboard'), array( $this, 'order_widgets' ) );
			wp_add_dashboard_widget('netbase_dashboard_amount_widgets', __('Amount', 'nb-dashboard'), array( $this, 'amount_widgets' ) );
			wp_add_dashboard_widget('netbase_dashboard_recent_order_widgets', __('Recent Orders', 'nb-dashboard'), array( $this, 'recent_order_widgets' ) );
		}
		wp_add_dashboard_widget('netbase_dashboard_analytics_widgets', __('Visitor', 'nb-dashboard'), array( $this, 'analytics_widgets' ) );
		wp_add_dashboard_widget('netbase_dashboard_username_widgets', __('Users', 'nb-dashboard'), array( $this, 'users_widgets' ) );
		wp_add_dashboard_widget('netbase_dashboard_best_selling_widgets', __('Best Selling Products', 'nb-dashboard'), array( $this, 'best_selling_widgets' ) );
		wp_add_dashboard_widget('netbase_dashboard_recent_buyer_widgets', __('Recent Buyers', 'nb-dashboard'), array( $this, 'recent_buyer_widgets' ) );
		wp_add_dashboard_widget('netbase_dashboard_recent_reviews_widgets', __('Recent Reviews', 'nb-dashboard'), array( $this, 'recent_reviews_widgets' ) );
		wp_add_dashboard_widget('netbase_dashboard_changelog_widgets', __('Changelog', 'nb-dashboard'), array( $this, 'changelog_widgets' ) );
		wp_add_dashboard_widget('netbase_dashboard_video_widgets', __('Video Tutorials', 'nb-dashboard'), array( $this, 'video_widgets' ) );
		//Google_Analytics_Admin::generate_stats_data()
	}

	public function netbase_dashboard_title_widget( $widget_key ) {
		switch ($widget_key) {
			case 'netbase_dashboard_order_widgets':
				$lists_order_status = wc_get_order_statuses();
				$chartorder = nbd_get_chartorder_default();

				?>
				<div class="admin-chart-option">
					<div class="admin-chart-range admin-order-status-filter">
						<span class="admin-order-status"><?php _e('Order Status', 'nb-dashboard');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<?php foreach( $lists_order_status as $k_status => $status_name ) {?>
							<span data-value="<?php echo esc_attr(str_replace('wc-', '', $k_status));?>"><?php echo esc_attr($status_name);?></span>
							<?php }?>
						</div>
					</div>
					<span class="admin-price"><?php echo $chartorder['total'];?></span>
					<div class="admin-chart-range admin-order-filter">
						<span class="value"><?php esc_html_e('Filter Range', 'printcart');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<span data-value="chartorder-this-week">This Week</span>
							<span data-value="chartorder-last-week">Last Week</span>
							<span data-value="chartorder-this-month">This Month</span>
							<span data-value="chartorder-last-month">Last Month</span>
							<span class="productsale-custom-range">Custom Range</span>
						</div>
						<input type="text" name="datefilter" value="" />
					</div>
				</div>
				<?php
				break;
			case 'netbase_dashboard_amount_widgets':
				$lists_order_status = wc_get_order_statuses();
				$chartamount = nbd_get_chartamount_default();

				?>
				<div class="admin-chart-option">
					<div class="admin-chart-range admin-order-status-filter">
						<span class="admin-order-status"><?php _e('Order Status', 'nb-dashboard');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<?php foreach( $lists_order_status as $k_status => $status_name ) {?>
							<span data-value="<?php echo esc_attr(str_replace('wc-', '', $k_status));?>"><?php echo esc_attr($status_name);?></span>
							<?php }?>
						</div>
					</div>
					<span class="admin-price"><?php echo $chartamount['total'];?></span>
					<div class="admin-chart-range admin-order-filter">
						<span class="value"><?php esc_html_e('Filter Range', 'printcart');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<span data-value="this-week">This Week</span>
							<span data-value="last-week">Last Week</span>
							<span data-value="this-month">This Month</span>
							<span data-value="last-month">Last Month</span>
							<span class="productsale-custom-range">Custom Range</span>
						</div>
						<input type="text" name="datefilter" value="" />
					</div>
				</div>
				<?php
				break;
			case 'netbase_dashboard_recent_order_widgets': ?>
				<p>Total paid invoices <?php echo $this->query_recent_orders->found_posts;?>, unpaid <?php echo $this->query_recent_orders_unpaid->found_posts;?></p>
				
				<div class="admin-chart-option">
					<span><a href="<?php echo home_url();?>/wp-admin/edit.php?post_type=shop_order"><?php esc_html_e('View all', 'printcart');?></a></span>
					<!--<div class="admin-chart-range">
						<span class="value"><?php esc_html_e('Filter Range', 'printcart');?> <i class="adminpanel-icon-arrow-down"></i></span>
					</div>-->
				</div>
				<?php
				break;
			case 'netbase_dashboard_analytics_widgets': ?>
				<p><?php _e('monthly stats', 'nb-dashboard');?></p>
				<?php
				break;
			case 'netbase_dashboard_username_widgets': ?>
				<a class="view-all" href="<?php echo home_url('wp-admin/users.php');?>">View all</a>
				<?php
				break;
			case 'netbase_dashboard_best_selling_widgets': ?>
				<a href="#" class="bestseller-refresh"><i class="adminpanel-icon-loop2"></i></a>
				<?php
				break;

			default:
				# code...
				break;
		}
	}

	public function order_widgets() {
		$lists_order_status = wc_get_order_statuses();
		$chartorder = nbd_get_chartorder_default();

		include_once NBDB_ABSPATH .'templates/chart-order-widget.php';
	}

	public function amount_widgets() {
		$lists_order_status = wc_get_order_statuses();
		$chartamount = nbd_get_chartamount_default();

		include_once NBDB_ABSPATH .'templates/chart-amount-widget.php';
	}

	public function recent_order_widgets() {
		include_once NBDB_ABSPATH .'templates/recent-order-widget.php';
	}

	public function analytics_widgets() {
		$analytics_stats = Google_Analytics_Admin::generate_stats_data();
		include_once NBDB_ABSPATH .'templates/google-analytics-widget.php';
	}

	public function users_widgets() {
		$usernames = nbd_get_lists_user();
		include_once NBDB_ABSPATH .'templates/users-widget.php';
	}
	
	public function best_selling_widgets() {
		$sell_product_args = array(
			'post_type' => 'product',
			'meta_key' => 'total_sales',
			'orderby' => 'meta_value_num',
			'posts_per_page' => 5,
		);

		$this->query_seller = new WP_Query( $sell_product_args );

		include_once NBDB_ABSPATH .'templates/best-selling-widget.php';
	}
	
	public function recent_buyer_widgets() {
		$get_best_buyer = nbd_get_best_buyer();

		include_once NBDB_ABSPATH .'templates/recent-buyer-widget.php';
	}

	public function recent_reviews_widgets() {
		/* Comments */
		$comment_args = array( 
			'number'      => 10, 
			'status'      => 'approve', 
			'post_status' => 'publish', 
			'post_type'   => 'product' 
		);

		$comments = get_comments( $comment_args );

		include_once NBDB_ABSPATH .'templates/recent-reviews-widget.php';
	}

	public function changelog_widgets() {
		$changelogs = nbd_get_changelog();

		include_once NBDB_ABSPATH .'templates/changelog-widget.php';
	}

	public function video_widgets() {
		$videos = nbd_get_video();
		
		include_once NBDB_ABSPATH .'templates/video-widget.php';
	}
	
}

new NB_Dashboard_Widget();
}