<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists('NBD_Analytics') ) {
	class NBD_Analytics extends NBD_Singleton {

	    /**
	     * NPC_Register constructor.
	     *
	     * @since 0.1.0
	     */
	    public function __construct() {
            require_once NBDB_ABSPATH . 'includes/analytics/Google_Analytics_Cache.php';
            require_once NBDB_ABSPATH . 'includes/analytics/vendor/Google_Analytics_API_Request.php';
            require_once NBDB_ABSPATH . 'includes/analytics/vendor/Google_Analytics_API_Response.php';
            require_once NBDB_ABSPATH . 'includes/analytics/vendor/Google_Analytics_API.php';
            require_once NBDB_ABSPATH . 'includes/analytics/vendor/Google_Analytics_API_Client.php';

            require_once NBDB_ABSPATH . 'includes/analytics/Google_Analytics_Helper.php';
            require_once NBDB_ABSPATH . 'includes/analytics/Google_Analytics_Stats.php';
            require_once NBDB_ABSPATH . 'includes/analytics/Google_Analytics_Admin.php';
            add_action( 'init', 'Google_Analytics_Helper::init' );

            if( isset($_GET['alt_action']) && $_GET['alt_action'] == 'ga_action_auth' ) {
                self::alt_action_auth();
            }
	    }

        /**
         * Redirects to Google oauth authentication endpoint.
         */
        public static function alt_action_auth() {
            header( 'Location:' . Google_Analytics_Admin::api_client()->create_auth_url() );
        }
	}
	
	new NBD_Analytics();
}





